/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.Klass;
import klass.model.meta.domain.KlassFinder;
import klass.model.meta.domain.KlassList;
import klass.model.meta.domain.json.view.KlassProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class KlassResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public KlassResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/class/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={KlassProjection_JsonView.class})
    public Klass method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.name().eq(name);
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties());
        result.deepFetch((Navigation)KlassFinder.superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.associationEnds());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (Klass)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/class")
    @Produces(value={"application/json"})
    @JsonView(value={KlassProjection_JsonView.class})
    public List<Klass> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.all();
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties());
        result.deepFetch((Navigation)KlassFinder.superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.associationEnds());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties());
        result.setOrderBy((OrderBy)KlassFinder.classifierSuperClass().packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }
}

