/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.NamedProjection;
import klass.model.meta.domain.NamedProjectionFinder;
import klass.model.meta.domain.NamedProjectionList;
import klass.model.meta.domain.json.view.NamedProjectionProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class NamedProjectionResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public NamedProjectionResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/projection/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={NamedProjectionProjection_JsonView.class})
    public NamedProjection method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = NamedProjectionFinder.name().eq(name);
        NamedProjectionList result = NamedProjectionFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)NamedProjectionFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)NamedProjectionFinder.rootProjection().projectionElementSuperClass());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (NamedProjection)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/projection")
    @Produces(value={"application/json"})
    @JsonView(value={NamedProjectionProjection_JsonView.class})
    public List<NamedProjection> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = NamedProjectionFinder.all();
        NamedProjectionList result = NamedProjectionFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)NamedProjectionFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)NamedProjectionFinder.rootProjection().projectionElementSuperClass());
        result.setOrderBy((OrderBy)NamedProjectionFinder.packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }
}

