/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.Classifier;
import klass.model.meta.domain.ClassifierFinder;
import klass.model.meta.domain.ClassifierList;
import klass.model.meta.domain.json.view.ClassifierProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class ClassifierResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public ClassifierResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/classifier/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={ClassifierProjection_JsonView.class})
    public Classifier method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = ClassifierFinder.name().eq(name);
        ClassifierList result = ClassifierFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)ClassifierFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)ClassifierFinder.superInterfaces());
        result.deepFetch((Navigation)ClassifierFinder.classifierModifiers());
        result.deepFetch((Navigation)ClassifierFinder.dataTypeProperties());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().associationEnds());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().parameterizedProperties());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (Classifier)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/classifier")
    @Produces(value={"application/json"})
    @JsonView(value={ClassifierProjection_JsonView.class})
    public List<Classifier> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = ClassifierFinder.all();
        ClassifierList result = ClassifierFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)ClassifierFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)ClassifierFinder.superInterfaces());
        result.deepFetch((Navigation)ClassifierFinder.classifierModifiers());
        result.deepFetch((Navigation)ClassifierFinder.dataTypeProperties());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().associationEnds());
        result.deepFetch((Navigation)ClassifierFinder.klassSubClass().parameterizedProperties());
        result.setOrderBy((OrderBy)ClassifierFinder.packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }
}

