/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.deserializer.json.OperationMode;
import cool.klass.deserializer.json.RequiredPropertiesValidator;
import cool.klass.deserializer.json.type.ObjectNodeTypeCheckingValidator;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.reladomo.persistent.writer.IncomingUpdateDataModelValidator;
import cool.klass.reladomo.persistent.writer.MutationContext;
import cool.klass.reladomo.persistent.writer.PersistentDeleter;
import cool.klass.reladomo.persistent.writer.PersistentReplacer;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.Klass;
import klass.model.meta.domain.KlassFinder;
import klass.model.meta.domain.KlassList;
import klass.model.meta.domain.json.view.KlassProjection_JsonView;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class KlassResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public KlassResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/class/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={KlassProjection_JsonView.class})
    public Klass method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.name().eq(name);
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties());
        result.deepFetch((Navigation)KlassFinder.superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.associationEnds());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (Klass)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @PUT
    @Path(value="/meta/class/{name}")
    @Produces(value={"application/json"})
    public void method1(@PathParam(value="name") String name, @Nonnull @NotNull ObjectNode incomingInstance) {
        cool.klass.model.meta.domain.api.Klass klass = this.domainModel.getClassByName("Klass");
        MutableList errors = Lists.mutable.empty();
        MutableList warnings = Lists.mutable.empty();
        ObjectNodeTypeCheckingValidator.validate((MutableList)errors, (JsonNode)incomingInstance, (cool.klass.model.meta.domain.api.Klass)klass);
        RequiredPropertiesValidator.validate((MutableList)errors, (MutableList)warnings, (cool.klass.model.meta.domain.api.Klass)klass, (ObjectNode)incomingInstance, (OperationMode)OperationMode.REPLACE);
        if (errors.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        if (warnings.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)warnings).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.name().eq(name);
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().minLengthValidation());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().maxLengthValidation());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties().parameterizedPropertyOrderings());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        if (result.size() > 1) {
            throw new InternalServerErrorException("TODO");
        }
        Object persistentInstance = result.get(0);
        Instant transactionInstant = Instant.now(this.clock);
        MutationContext mutationContext = new MutationContext(Optional.empty(), transactionInstant, Maps.immutable.empty());
        cool.klass.model.meta.domain.api.Klass userKlass = (cool.klass.model.meta.domain.api.Klass)this.domainModel.getUserClass().get();
        IncomingUpdateDataModelValidator.validate((DataStore)this.dataStore, (cool.klass.model.meta.domain.api.Klass)userKlass, (cool.klass.model.meta.domain.api.Klass)klass, (MutationContext)mutationContext, (Object)persistentInstance, (ObjectNode)incomingInstance, (MutableList)errors, (MutableList)warnings);
        if (errors.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        if (warnings.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)warnings).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        PersistentReplacer replacer = new PersistentReplacer(mutationContext, this.dataStore);
        replacer.synchronize(klass, persistentInstance, incomingInstance);
    }

    @Timed
    @ExceptionMetered
    @DELETE
    @Path(value="/meta/class/{name}")
    @Produces(value={"application/json"})
    public void method2(@PathParam(value="name") String name) {
        cool.klass.model.meta.domain.api.Klass klass = this.domainModel.getClassByName("Klass");
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.name().eq(name);
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().minLengthValidation());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().maxLengthValidation());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties().parameterizedPropertyOrderings());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        if (result.size() > 1) {
            throw new InternalServerErrorException("TODO");
        }
        Object persistentInstance = result.get(0);
        Instant transactionInstant = Instant.now(this.clock);
        MutationContext mutationContext = new MutationContext(Optional.empty(), transactionInstant, Maps.immutable.empty());
        PersistentDeleter deleter = new PersistentDeleter(mutationContext, this.dataStore);
        deleter.deleteOrTerminate(klass, persistentInstance);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/class")
    @Produces(value={"application/json"})
    @JsonView(value={KlassProjection_JsonView.class})
    public List<Klass> method3() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.all();
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties());
        result.deepFetch((Navigation)KlassFinder.superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)KlassFinder.associationEnds());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties());
        result.setOrderBy((OrderBy)KlassFinder.classifierSuperClass().packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }

    @Timed
    @ExceptionMetered
    @PUT
    @Path(value="/meta/class")
    @Produces(value={"application/json"})
    public void method4(@Nonnull @NotNull ObjectNode incomingInstance) {
        cool.klass.model.meta.domain.api.Klass klass = this.domainModel.getClassByName("Klass");
        MutableList errors = Lists.mutable.empty();
        MutableList warnings = Lists.mutable.empty();
        ObjectNodeTypeCheckingValidator.validate((MutableList)errors, (JsonNode)incomingInstance, (cool.klass.model.meta.domain.api.Klass)klass);
        RequiredPropertiesValidator.validate((MutableList)errors, (MutableList)warnings, (cool.klass.model.meta.domain.api.Klass)klass, (ObjectNode)incomingInstance, (OperationMode)OperationMode.REPLACE);
        if (errors.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        if (warnings.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)warnings).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.all();
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().minLengthValidation());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().maxLengthValidation());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties().parameterizedPropertyOrderings());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        if (result.size() > 1) {
            throw new InternalServerErrorException("TODO");
        }
        Object persistentInstance = result.get(0);
        Instant transactionInstant = Instant.now(this.clock);
        MutationContext mutationContext = new MutationContext(Optional.empty(), transactionInstant, Maps.immutable.empty());
        cool.klass.model.meta.domain.api.Klass userKlass = (cool.klass.model.meta.domain.api.Klass)this.domainModel.getUserClass().get();
        IncomingUpdateDataModelValidator.validate((DataStore)this.dataStore, (cool.klass.model.meta.domain.api.Klass)userKlass, (cool.klass.model.meta.domain.api.Klass)klass, (MutationContext)mutationContext, (Object)persistentInstance, (ObjectNode)incomingInstance, (MutableList)errors, (MutableList)warnings);
        if (errors.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        if (warnings.notEmpty()) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)warnings).build();
            throw new BadRequestException("Incoming data failed validation.", response);
        }
        PersistentReplacer replacer = new PersistentReplacer(mutationContext, this.dataStore);
        replacer.synchronize(klass, persistentInstance, incomingInstance);
    }

    @Timed
    @ExceptionMetered
    @DELETE
    @Path(value="/meta/class")
    @Produces(value={"application/json"})
    public void method5() {
        cool.klass.model.meta.domain.api.Klass klass = this.domainModel.getClassByName("Klass");
        com.gs.fw.common.mithra.finder.Operation queryOperation = KlassFinder.all();
        KlassList result = KlassFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().superInterfaces());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().classifierModifiers());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().minLengthValidation());
        result.deepFetch((Navigation)KlassFinder.classifierSuperClass().dataTypeProperties().maxLengthValidation());
        result.deepFetch((Navigation)KlassFinder.parameterizedProperties().parameterizedPropertyOrderings());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        if (result.size() > 1) {
            throw new InternalServerErrorException("TODO");
        }
        Object persistentInstance = result.get(0);
        Instant transactionInstant = Instant.now(this.clock);
        MutationContext mutationContext = new MutationContext(Optional.empty(), transactionInstant, Maps.immutable.empty());
        PersistentDeleter deleter = new PersistentDeleter(mutationContext, this.dataStore);
        deleter.deleteOrTerminate(klass, persistentInstance);
    }
}

