/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.PackageableElement;
import klass.model.meta.domain.PackageableElementFinder;
import klass.model.meta.domain.PackageableElementList;
import klass.model.meta.domain.json.view.PackageableElementProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class PackageableElementResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public PackageableElementResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/packageableElement/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={PackageableElementProjection_JsonView.class})
    public PackageableElement method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = PackageableElementFinder.name().eq(name);
        PackageableElementList result = PackageableElementFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)PackageableElementFinder.enumerationSubClass().enumerationLiterals());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().superInterfaces());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().classifierModifiers());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().dataTypeProperties());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass().superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass().parameterizedProperties());
        result.deepFetch((Navigation)PackageableElementFinder.associationSubClass().associationEnds());
        result.deepFetch((Navigation)PackageableElementFinder.associationSubClass().criteria());
        result.deepFetch((Navigation)PackageableElementFinder.namedProjectionSubClass().rootProjection().projectionElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.serviceGroupSubClass().owningClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.serviceGroupSubClass().urls());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (PackageableElement)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/packageableElement")
    @Produces(value={"application/json"})
    @JsonView(value={PackageableElementProjection_JsonView.class})
    public List<PackageableElement> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = PackageableElementFinder.all();
        PackageableElementList result = PackageableElementFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)PackageableElementFinder.enumerationSubClass().enumerationLiterals());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().superInterfaces());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().classifierModifiers());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().dataTypeProperties());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass().superClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.classifierSubClass().klassSubClass().parameterizedProperties());
        result.deepFetch((Navigation)PackageableElementFinder.associationSubClass().associationEnds());
        result.deepFetch((Navigation)PackageableElementFinder.associationSubClass().criteria());
        result.deepFetch((Navigation)PackageableElementFinder.namedProjectionSubClass().rootProjection().projectionElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.serviceGroupSubClass().owningClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)PackageableElementFinder.serviceGroupSubClass().urls());
        result.setOrderBy((OrderBy)PackageableElementFinder.ordinal().ascendingOrderBy());
        return result;
    }
}

