/*
 * Decompiled with CFR 0.152.
 */
package klass.model.meta.domain.service.resource;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonView;
import com.gs.fw.finder.Navigation;
import com.gs.fw.finder.Operation;
import com.gs.fw.finder.OrderBy;
import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.DomainModel;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import klass.model.meta.domain.ServiceGroup;
import klass.model.meta.domain.ServiceGroupFinder;
import klass.model.meta.domain.ServiceGroupList;
import klass.model.meta.domain.json.view.ServiceGroupProjection_JsonView;
import org.eclipse.collections.impl.utility.Iterate;

@Path(value="/")
public class ServiceGroupResource {
    @Nonnull
    private final DomainModel domainModel;
    @Nonnull
    private final DataStore dataStore;
    @Nonnull
    private final Clock clock;

    public ServiceGroupResource(@Nonnull DomainModel domainModel, @Nonnull DataStore dataStore, @Nonnull Clock clock) {
        this.domainModel = Objects.requireNonNull(domainModel);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.clock = Objects.requireNonNull(clock);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/serviceGroup/{name}")
    @Produces(value={"application/json"})
    @JsonView(value={ServiceGroupProjection_JsonView.class})
    public ServiceGroup method0(@PathParam(value="name") String name) {
        com.gs.fw.common.mithra.finder.Operation queryOperation = ServiceGroupFinder.name().eq(name);
        ServiceGroupList result = ServiceGroupFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)ServiceGroupFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)ServiceGroupFinder.owningClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)ServiceGroupFinder.urls());
        if (result.isEmpty()) {
            throw new ClientErrorException("Url valid, data not found.", Response.Status.GONE);
        }
        return (ServiceGroup)Iterate.getOnly((Iterable)result);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/serviceGroup")
    @Produces(value={"application/json"})
    @JsonView(value={ServiceGroupProjection_JsonView.class})
    public List<ServiceGroup> method1() {
        com.gs.fw.common.mithra.finder.Operation queryOperation = ServiceGroupFinder.all();
        ServiceGroupList result = ServiceGroupFinder.findMany((Operation)queryOperation);
        result.deepFetch((Navigation)ServiceGroupFinder.packageableElementSuperClass());
        result.deepFetch((Navigation)ServiceGroupFinder.owningClass().classifierSuperClass().packageableElementSuperClass());
        result.deepFetch((Navigation)ServiceGroupFinder.urls());
        result.setOrderBy((OrderBy)ServiceGroupFinder.packageableElementSuperClass().ordinal().ascendingOrderBy());
        return result;
    }
}

