/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.loader.compiler;

import com.google.common.base.Predicate;
import cool.klass.model.converter.compiler.CompilationResult;
import cool.klass.model.converter.compiler.CompilationUnit;
import cool.klass.model.converter.compiler.KlassCompiler;
import cool.klass.model.converter.compiler.annotation.RootCompilerAnnotation;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.loader.DomainModelLoader;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainModelCompilerLoader
implements DomainModelLoader {
    public static final Pattern KLASS_FILE_EXTENSION = Pattern.compile(".*\\.klass");
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainModelCompilerLoader.class);
    @Nonnull
    private final ImmutableList<String> klassSourcePackages;
    @Nonnull
    private final ClassLoader classLoader;
    @Nonnull
    private final Consumer<RootCompilerAnnotation> compilerAnnotationHandler;

    public DomainModelCompilerLoader(@Nonnull ImmutableList<String> klassSourcePackages) {
        this(klassSourcePackages, Thread.currentThread().getContextClassLoader(), DomainModelCompilerLoader::logCompilerAnnotation);
    }

    public DomainModelCompilerLoader(@Nonnull ImmutableList<String> klassSourcePackages, @Nonnull ClassLoader classLoader) {
        this(klassSourcePackages, classLoader, DomainModelCompilerLoader::logCompilerAnnotation);
    }

    public DomainModelCompilerLoader(@Nonnull ImmutableList<String> klassSourcePackages, @Nonnull ClassLoader classLoader, @Nonnull Consumer<RootCompilerAnnotation> compilerAnnotationHandler) {
        this.klassSourcePackages = Objects.requireNonNull(klassSourcePackages);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.compilerAnnotationHandler = Objects.requireNonNull(compilerAnnotationHandler);
    }

    public static void logCompilerError(RootCompilerAnnotation compilerAnnotation) {
        if (compilerAnnotation.isError()) {
            LOGGER.error("{}", (Object)compilerAnnotation);
        }
    }

    public static void logCompilerAnnotation(RootCompilerAnnotation compilerAnnotation) {
        if (compilerAnnotation.isError()) {
            LOGGER.error("{}", (Object)compilerAnnotation);
        } else {
            LOGGER.warn("{}", (Object)compilerAnnotation);
        }
    }

    @Nonnull
    public DomainModelWithSourceCode load() {
        LOGGER.info("Scanning source packages: {}", this.klassSourcePackages);
        Instant start = Instant.now();
        ImmutableList<CompilationUnit> compilationUnits = this.getCompilationUnits();
        KlassCompiler klassCompiler = new KlassCompiler(compilationUnits);
        CompilationResult compilationResult = klassCompiler.compile();
        DomainModelWithSourceCode domainModel = this.handleResult(compilationResult);
        Instant end = Instant.now();
        Duration duration = Duration.between(start, end);
        String durationPrettyString = duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
        LOGGER.info("Domain model compilation completed in {}", (Object)durationPrettyString);
        return domainModel;
    }

    @Nonnull
    private ImmutableList<CompilationUnit> getCompilationUnits() {
        ImmutableList urls = this.klassSourcePackages.flatCollectWith((Function2 & Serializable)(x$0, xva$1) -> ClasspathHelper.forPackage((String)x$0, (ClassLoader[])new ClassLoader[]{xva$1}), (Object)this.classLoader);
        FilterBuilder filterBuilder = new FilterBuilder();
        this.klassSourcePackages.forEach((Procedure & Serializable)xva$0 -> filterBuilder.includePackage(new String[]{xva$0}));
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)urls.castToList()).filterInputsBy((Predicate)filterBuilder);
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        ImmutableList klassLocations = Lists.immutable.withAll((Iterable)reflections.getResources(KLASS_FILE_EXTENSION));
        LOGGER.debug("Found source files on classpath: {}", (Object)klassLocations);
        ImmutableList compilationUnits = klassLocations.collectWithIndex((ObjectIntToObjectFunction & Serializable)(each, index) -> CompilationUnit.createFromClasspathLocation((int)index, (String)each));
        if (compilationUnits.isEmpty()) {
            String message = "Could not find any files matching *.klass in urls: " + urls;
            throw new RuntimeException(message);
        }
        return compilationUnits;
    }

    @Nonnull
    private DomainModelWithSourceCode handleResult(@Nonnull CompilationResult compilationResult) {
        ImmutableList compilerAnnotations = compilationResult.compilerAnnotations();
        for (RootCompilerAnnotation compilerAnnotation : compilerAnnotations) {
            this.compilerAnnotationHandler.accept(compilerAnnotation);
        }
        if (compilationResult.domainModelWithSourceCode().isEmpty()) {
            throw new RuntimeException("There were compiler errors.");
        }
        return (DomainModelWithSourceCode)compilationResult.domainModelWithSourceCode().get();
    }
}

