/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api;

import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public interface Klass
extends Classifier {
    @Override
    default public void visit(TopLevelElementVisitor visitor) {
        visitor.visitKlass(this);
    }

    @Override
    default public ImmutableList<Modifier> getInheritedModifiers() {
        ImmutableList superClassModifiers = this.getSuperClass().map(Classifier::getModifiers).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
        ImmutableList<Modifier> interfaceModifiers = Classifier.super.getInheritedModifiers();
        ImmutableList allModifiers = superClassModifiers.newWithAll(interfaceModifiers);
        return allModifiers.distinctBy(Modifier::getKeyword);
    }

    public ImmutableList<AssociationEnd> getDeclaredAssociationEnds();

    public AssociationEnd getDeclaredAssociationEndByName(String var1);

    public ImmutableList<AssociationEnd> getAssociationEnds();

    public AssociationEnd getAssociationEndByName(String var1);

    @Override
    @Nonnull
    default public ImmutableList<Property> getProperties() {
        return Lists.immutable.empty().newWithAll(this.getDataTypeProperties()).newWithAll(this.getAssociationEnds());
    }

    @Override
    default public ImmutableList<Property> getDeclaredProperties() {
        return Lists.immutable.empty().newWithAll(this.getDeclaredDataTypeProperties()).newWithAll(this.getDeclaredAssociationEnds());
    }

    @Override
    default public boolean isUniquelyOwned() {
        return this.getAssociationEnds().asLazy().reject(ReferenceProperty::isToSelf).collect(AssociationEnd::getOpposite).count(ReferenceProperty::isOwned) == 1;
    }

    @Nonnull
    default public Optional<Property> getPropertyByName(String name) {
        DataTypeProperty dataTypeProperty = this.getDataTypePropertyByName(name);
        AssociationEnd associationEnd = this.getAssociationEndByName(name);
        if (dataTypeProperty != null && associationEnd != null) {
            String detailMessage = "Property " + name + " is both a data type property and an association end.";
            throw new AssertionError((Object)detailMessage);
        }
        if (dataTypeProperty != null) {
            return Optional.of(dataTypeProperty);
        }
        if (associationEnd != null) {
            return Optional.of(associationEnd);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<AssociationEnd> getVersionProperty();

    @Nonnull
    public Optional<AssociationEnd> getVersionedProperty();

    default public Optional<DataTypeProperty> getVersionNumberProperty() {
        ImmutableList versionProperties = this.getDataTypeProperties().select(DataTypeProperty::isVersion);
        if (versionProperties.size() > 1) {
            throw new AssertionError();
        }
        if (versionProperties.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((DataTypeProperty)versionProperties.getOnly());
    }

    @Nonnull
    public Optional<Klass> getSuperClass();

    public ImmutableList<Klass> getSubClasses();

    public boolean isUser();

    public boolean isTransient();

    default public boolean isVersioned() {
        return this.getVersionProperty().isPresent();
    }

    default public boolean isAudited() {
        return this.getDataTypeProperties().anySatisfy(DataTypeProperty::isAudit);
    }

    @Override
    default public boolean isStrictSuperTypeOf(@Nonnull Classifier classifier) {
        if (Classifier.super.isStrictSuperTypeOf(classifier)) {
            return true;
        }
        if (this == classifier) {
            return false;
        }
        if (classifier instanceof Interface) {
            return false;
        }
        Klass klass = (Klass)classifier;
        Optional<Klass> optionalSuperClass = klass.getSuperClass();
        if (optionalSuperClass.isEmpty()) {
            return false;
        }
        Klass superClass = optionalSuperClass.get();
        if (this == superClass) {
            return true;
        }
        return this.isStrictSuperTypeOf(superClass);
    }

    @Override
    default public boolean isStrictSubTypeOf(Classifier classifier) {
        if (Classifier.super.isStrictSubTypeOf(classifier)) {
            return true;
        }
        if (this == classifier) {
            return false;
        }
        Optional<Klass> optionalSuperClass = this.getSuperClass();
        if (optionalSuperClass.isEmpty()) {
            return false;
        }
        Klass superClass = optionalSuperClass.get();
        if (superClass == classifier) {
            return true;
        }
        return superClass.isStrictSubTypeOf(classifier);
    }

    default public ImmutableList<Klass> getSubClassChain() {
        return this.getSubClasses().flatCollect(Klass::getSubClassChainWithThis).toImmutable();
    }

    default public ImmutableList<Klass> getSubClassChainWithThis() {
        return Lists.immutable.with((Object)this).newWithAll(this.getSubClassChain());
    }

    default public ImmutableList<Klass> getSuperClassChain() {
        return this.getSuperClass().map(Klass::getSuperClassChainWithThis).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
    }

    default public ImmutableList<Klass> getSuperClassChainWithThis() {
        return Lists.immutable.with((Object)this).newWithAll(this.getSuperClassChain());
    }
}

