/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api;

import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.visitor.PrimitiveTypeVisitor;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Lists;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PrimitiveType implements Element,
DataType,
DataType.DataTypeGetter
{
    INTEGER("Integer", true, (Class)Integer.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitInteger();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    LONG("Long", true, (Class)Long.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitLong();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    DOUBLE("Double", true, (Class)Double.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitDouble();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    FLOAT("Float", true, (Class)Float.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitFloat();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    BOOLEAN("Boolean", false, (Class)Boolean.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitBoolean();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    STRING("String", false, (Class)String.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitString();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    INSTANT("Instant", false, (Class)Instant.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitInstant();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    LOCAL_DATE("LocalDate", false, (Class)LocalDate.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitLocalDate();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    TEMPORAL_INSTANT("TemporalInstant", false, (Class)Instant.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitTemporalInstant();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    TEMPORAL_RANGE("TemporalRange", false, (Class)Instant.class){

        @Override
        public void visit(@Nonnull PrimitiveTypeVisitor visitor) {
            try {
                visitor.visitTemporalRange();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static final ImmutableList<PrimitiveType> PRIMITIVE_TYPES;
    public static final ImmutableList<PrimitiveType> ID_PRIMITIVE_TYPES;
    private static final ImmutableMap<String, PrimitiveType> BY_PRETTY_NAME;
    @Nonnull
    private final String prettyName;
    private final boolean isNumeric;
    @Nonnull
    private final Class<?> javaClass;

    private PrimitiveType(@Nonnull String prettyName, boolean isNumeric, Class<?> javaClass) {
        this.prettyName = Objects.requireNonNull(prettyName);
        this.isNumeric = isNumeric;
        this.javaClass = Objects.requireNonNull(javaClass);
    }

    public static PrimitiveType byPrettyName(String name) {
        return Objects.requireNonNull((PrimitiveType)BY_PRETTY_NAME.get((Object)name));
    }

    @Nonnull
    public String getPrettyName() {
        return this.prettyName;
    }

    @Override
    public String getDataTypeName() {
        return this.getPrettyName();
    }

    @Nonnull
    public String toString() {
        return this.getPrettyName();
    }

    public abstract void visit(@Nonnull PrimitiveTypeVisitor var1);

    public boolean isTemporal() {
        return this.isTemporalRange() || this.isTemporalInstant();
    }

    public boolean isTemporalRange() {
        return this == TEMPORAL_RANGE;
    }

    public boolean isTemporalInstant() {
        return this == TEMPORAL_INSTANT;
    }

    public boolean isId() {
        return ID_PRIMITIVE_TYPES.contains((Object)this);
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    @Nonnull
    public PrimitiveType getType() {
        return this;
    }

    @Override
    public Optional<Element> getMacroElement() {
        return Optional.empty();
    }

    @Override
    public String getName() {
        return this.getPrettyName();
    }

    static {
        PRIMITIVE_TYPES = Lists.immutable.with((Object)STRING, (Object)INTEGER, (Object)LONG, (Object)DOUBLE, (Object)FLOAT, (Object)BOOLEAN, (Object)INSTANT, (Object)LOCAL_DATE, (Object)TEMPORAL_INSTANT, (Object)TEMPORAL_RANGE);
        ID_PRIMITIVE_TYPES = Lists.immutable.with((Object)INTEGER, (Object)LONG, (Object)STRING);
        BY_PRETTY_NAME = PRIMITIVE_TYPES.groupByUniqueKey(PrimitiveType::getPrettyName);
    }
}

