/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api.property;

import cool.klass.model.meta.domain.api.DataType;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.validation.MaxLengthPropertyValidation;
import cool.klass.model.meta.domain.api.property.validation.MaxPropertyValidation;
import cool.klass.model.meta.domain.api.property.validation.MinLengthPropertyValidation;
import cool.klass.model.meta.domain.api.property.validation.MinPropertyValidation;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.OrderedMap;

public interface DataTypeProperty
extends Property {
    public void visit(@Nonnull DataTypePropertyVisitor var1);

    @Override
    @Nonnull
    public DataType getType();

    @Nonnull
    public ImmutableList<Modifier> getModifiers();

    public Optional<MinLengthPropertyValidation> getMinLengthPropertyValidation();

    public Optional<MaxLengthPropertyValidation> getMaxLengthPropertyValidation();

    public Optional<MinPropertyValidation> getMinPropertyValidation();

    public Optional<MaxPropertyValidation> getMaxPropertyValidation();

    public OrderedMap<AssociationEnd, DataTypeProperty> getKeysMatchingThisForeignKey();

    public OrderedMap<AssociationEnd, DataTypeProperty> getForeignKeysMatchingThisKey();

    default public boolean isKey() {
        return this.getModifiers().anySatisfy(Modifier::isKey);
    }

    public boolean isID();

    default public boolean isAudit() {
        return this.getModifiers().anySatisfy(Modifier::isAudit);
    }

    default public boolean isCreatedBy() {
        return this.getModifiers().anySatisfy(Modifier::isCreatedBy);
    }

    default public boolean isCreatedOn() {
        return this.getModifiers().anySatisfy(Modifier::isCreatedOn);
    }

    default public boolean isLastUpdatedBy() {
        return this.getModifiers().anySatisfy(Modifier::isLastUpdatedBy);
    }

    default public boolean isValid() {
        return this.getModifiers().anySatisfy(Modifier::isValid);
    }

    default public boolean isValidFrom() {
        return this.isValid() && this.isFrom();
    }

    default public boolean isValidTo() {
        return this.isValid() && this.isTo();
    }

    default public boolean isValidRange() {
        return this.isValid() && this.isTemporalRange();
    }

    default public boolean isSystem() {
        return this.getModifiers().anySatisfy(Modifier::isSystem);
    }

    default public boolean isSystemFrom() {
        return this.isSystem() && this.isFrom();
    }

    default public boolean isSystemTo() {
        return this.isSystem() && this.isTo();
    }

    default public boolean isSystemRange() {
        return this.isSystem() && this.isTemporalRange();
    }

    default public boolean isFrom() {
        return this.getModifiers().anySatisfy(Modifier::isFrom);
    }

    default public boolean isTo() {
        return this.getModifiers().anySatisfy(Modifier::isTo);
    }

    default public boolean isFinal() {
        return this.getModifiers().anySatisfy(Modifier::isFinal);
    }

    @Override
    default public boolean isPrivate() {
        return this.getModifiers().anySatisfy(Modifier::isPrivate);
    }

    default public boolean isValidTemporal() {
        return this.isValid() && this.isTemporalRange();
    }

    default public boolean isSystemTemporal() {
        return this.isSystem() && this.isTemporalRange();
    }

    public boolean isOptional();

    @Override
    default public boolean isRequired() {
        return !this.isOptional();
    }

    public boolean isTemporalRange();

    public boolean isTemporalInstant();

    public boolean isTemporal();

    public boolean isForeignKey();

    public boolean isForeignKeyToSelf();

    public boolean isVersion();

    @Override
    default public boolean isDerived() {
        return this.getModifiers().anySatisfy(Modifier::isDerived);
    }

    default public boolean isForeignKeyWithOpposite() {
        OrderedMap<AssociationEnd, DataTypeProperty> keysMatchingThisForeignKey = this.getKeysMatchingThisForeignKey();
        ImmutableList dataTypeProperties = keysMatchingThisForeignKey.valuesView().toList().toImmutable();
        return dataTypeProperties.anySatisfyWith((Predicate2 & Serializable)(dataTypeProperty, keyProperty1) -> keyProperty1.isOppositeKey((DataTypeProperty)dataTypeProperty), (Object)this);
    }

    default public boolean isOppositeKey(@Nonnull DataTypeProperty dataTypeProperty) {
        return dataTypeProperty.getForeignKeysMatchingThisKey().containsValue((Object)Lists.immutable.with((Object)this));
    }

    default public boolean isForeignKeyMatchingKeyOnPath(AssociationEnd pathHere) {
        AssociationEnd opposite = pathHere.getOpposite();
        return this.getKeysMatchingThisForeignKey().containsKey((Object)opposite);
    }
}

