/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api;

import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.TopLevelElement;
import cool.klass.model.meta.domain.api.Type;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.modifier.ModifierOwner;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public interface Classifier
extends Type,
ModifierOwner,
TopLevelElement {
    public boolean isAbstract();

    @Nonnull
    public ImmutableList<Interface> getInterfaces();

    @Nonnull
    default public ImmutableList<Modifier> getModifiers() {
        Objects.requireNonNull(this.getDeclaredModifiers());
        MutableSet propertyNames = this.getDeclaredModifiers().collect(Modifier::getKeyword).toSet();
        ImmutableList inheritedProperties = this.getInheritedModifiers().reject((Predicate & Serializable)inheritedProperty -> propertyNames.contains((Object)inheritedProperty.getKeyword()));
        return this.getDeclaredModifiers().newWithAll((Iterable)inheritedProperties);
    }

    default public ImmutableList<Modifier> getInheritedModifiers() {
        return this.getInterfaces().flatCollect(Classifier::getModifiers).distinctBy(Modifier::getKeyword).toImmutable();
    }

    @Nonnull
    public ImmutableList<Modifier> getDeclaredModifiers();

    @Nonnull
    public ImmutableList<Property> getProperties();

    public ImmutableList<Property> getDeclaredProperties();

    public ImmutableList<DataTypeProperty> getKeyProperties();

    @Nonnull
    public ImmutableList<DataTypeProperty> getDataTypeProperties();

    @Nonnull
    public ImmutableList<DataTypeProperty> getDeclaredDataTypeProperties();

    public DataTypeProperty getDataTypePropertyByName(String var1);

    public ImmutableList<ReferenceProperty> getDeclaredReferenceProperties();

    public ImmutableList<ReferenceProperty> getReferenceProperties();

    public boolean isUniquelyOwned();

    default public boolean isTemporal() {
        return this.isSystemTemporal() || this.isValidTemporal();
    }

    default public boolean isBitemporal() {
        return this.isSystemTemporal() && this.isValidTemporal();
    }

    default public boolean isSystemTemporal() {
        return this.getDataTypeProperties().anySatisfy(DataTypeProperty::isSystemTemporal);
    }

    default public boolean isValidTemporal() {
        return this.getDataTypeProperties().anySatisfy(DataTypeProperty::isValidTemporal);
    }

    default public boolean isStrictSuperTypeOf(@Nonnull Classifier classifier) {
        if (this == classifier) {
            return false;
        }
        ImmutableList<Interface> superInterfaces = classifier.getInterfaces();
        if (superInterfaces.contains((Object)this)) {
            return true;
        }
        return superInterfaces.anySatisfy(this::isStrictSuperTypeOf);
    }

    default public boolean isSubTypeOf(Classifier classifier) {
        if (this == classifier) {
            return true;
        }
        return this.isStrictSubTypeOf(classifier);
    }

    default public boolean isStrictSubTypeOf(Classifier classifier) {
        if (this == classifier) {
            return false;
        }
        if (classifier instanceof Klass) {
            return false;
        }
        ImmutableList<Interface> superInterfaces = this.getInterfaces();
        if (superInterfaces.contains((Object)classifier)) {
            return true;
        }
        return superInterfaces.anySatisfyWith(Classifier::isStrictSubTypeOf, (Object)classifier);
    }

    @Nonnull
    default public MutableOrderedMap<AssociationEnd, MutableOrderedMap<DataTypeProperty, DataTypeProperty>> getForeignKeys() {
        MutableOrderedMap foreignKeyConstraints = OrderedMapAdapter.adapt(new LinkedHashMap());
        for (DataTypeProperty foreignKey : this.getDeclaredDataTypeProperties()) {
            OrderedMap<AssociationEnd, DataTypeProperty> keysMatchingThisForeignKey = foreignKey.getKeysMatchingThisForeignKey();
            keysMatchingThisForeignKey.forEachKeyValue((Procedure2 & Serializable)(associationEnd, key) -> {
                MutableOrderedMap dataTypeProperties = (MutableOrderedMap)foreignKeyConstraints.computeIfAbsent(associationEnd, ignored -> OrderedMapAdapter.adapt(new LinkedHashMap()));
                dataTypeProperties.put((Object)foreignKey, key);
            });
        }
        return foreignKeyConstraints;
    }

    public Optional<PrimitiveProperty> getSystemProperty();

    public Optional<PrimitiveProperty> getSystemFromProperty();

    public Optional<PrimitiveProperty> getSystemToProperty();

    public Optional<PrimitiveProperty> getValidProperty();

    public Optional<PrimitiveProperty> getValidFromProperty();

    public Optional<PrimitiveProperty> getValidToProperty();

    public Optional<PrimitiveProperty> getCreatedByProperty();

    public Optional<PrimitiveProperty> getCreatedOnProperty();

    public Optional<PrimitiveProperty> getLastUpdatedByProperty();
}

