/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api.property;

import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.modifier.Modifier;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.property.Property;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;

public interface ReferenceProperty
extends Property {
    @Nonnull
    public Multiplicity getMultiplicity();

    @Override
    default public boolean isRequired() {
        return this.getMultiplicity().isRequired();
    }

    @Override
    default public boolean isDerived() {
        return false;
    }

    @Nonnull
    public Optional<OrderBy> getOrderBy();

    @Override
    @Nonnull
    public Classifier getType();

    @Nonnull
    public ImmutableList<Modifier> getModifiers();

    default public boolean isOwned() {
        return this.getModifiers().anySatisfy((Predicate & Serializable)modifier -> modifier.is("owned"));
    }

    default public boolean isVersion() {
        return this.getModifiers().anySatisfy(Modifier::isVersion);
    }

    default public boolean isAudit() {
        return this.isCreatedBy() || this.isLastUpdatedBy();
    }

    default public boolean isCreatedBy() {
        return this.getModifiers().anySatisfy(Modifier::isCreatedBy);
    }

    default public boolean isLastUpdatedBy() {
        return this.getModifiers().anySatisfy(Modifier::isLastUpdatedBy);
    }

    default public boolean isFinal() {
        return this.getModifiers().anySatisfy(Modifier::isFinal);
    }

    @Override
    default public boolean isPrivate() {
        return this.getModifiers().anySatisfy(Modifier::isPrivate);
    }

    default public boolean isToSelf() {
        return this.getOwningClassifier().equals(this.getType());
    }
}

