/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.api.service;

import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.criteria.Criteria;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.service.ServiceMultiplicity;
import cool.klass.model.meta.domain.api.service.ServiceProjectionDispatch;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.domain.api.service.url.Url;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface Service
extends Element {
    @Nonnull
    public Url getUrl();

    @Nonnull
    public Verb getVerb();

    @Nonnull
    public ServiceMultiplicity getServiceMultiplicity();

    @Nonnull
    public Optional<Criteria> getQueryCriteria();

    @Nonnull
    public Optional<Criteria> getAuthorizeCriteria();

    @Nonnull
    public Optional<Criteria> getValidateCriteria();

    @Nonnull
    public Optional<Criteria> getConflictCriteria();

    public Optional<ServiceProjectionDispatch> getProjectionDispatch();

    @Nonnull
    public Optional<OrderBy> getOrderBy();

    default public int getNumParameters() {
        int numUrlParameters = this.getUrl().getParameters().size();
        int numVersionParameters = this.isVersionClauseRequired() ? 1 : 0;
        int numAuthorizeParameters = this.isAuthorizeClauseRequired() ? 1 : 0;
        return numUrlParameters + numVersionParameters + numAuthorizeParameters;
    }

    default public boolean isVersionClauseRequired() {
        return this.getServiceMultiplicity() == ServiceMultiplicity.ONE && this.getUrl().getServiceGroup().getKlass().getVersionProperty().isPresent();
    }

    default public boolean isAuthorizeClauseRequired() {
        return this.getAuthorizeCriteria().isPresent();
    }
}

