/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain;

import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.source.ElementWithSourceCode;
import cool.klass.model.meta.domain.api.source.SourceCode;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public abstract class AbstractElement
implements ElementWithSourceCode {
    @Nonnull
    private final ParserRuleContext elementContext;
    @Nonnull
    private final Optional<Element> macroElement;
    @Nullable
    private final SourceCode sourceCode;

    protected AbstractElement(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<Element> macroElement, @Nullable SourceCode sourceCode) {
        this.elementContext = Objects.requireNonNull(elementContext);
        this.macroElement = Objects.requireNonNull(macroElement);
        this.sourceCode = sourceCode;
    }

    @Nonnull
    public Optional<Element> getMacroElement() {
        return this.macroElement;
    }

    public SourceCode getSourceCodeObject() {
        return Objects.requireNonNull(this.sourceCode);
    }

    @Nonnull
    public ParserRuleContext getElementContext() {
        return this.elementContext;
    }

    public static abstract class ElementBuilder<BuiltElement extends Element> {
        @Nonnull
        protected final ParserRuleContext elementContext;
        @Nonnull
        protected final Optional<ElementBuilder<?>> macroElement;
        @Nullable
        protected final SourceCode.SourceCodeBuilder sourceCode;
        protected BuiltElement element;

        protected ElementBuilder(@Nonnull ParserRuleContext elementContext, @Nonnull Optional<ElementBuilder<?>> macroElement, @Nullable SourceCode.SourceCodeBuilder sourceCode) {
            this.elementContext = Objects.requireNonNull(elementContext);
            this.macroElement = Objects.requireNonNull(macroElement);
            this.sourceCode = sourceCode;
        }

        @Nonnull
        public final BuiltElement build() {
            if (this.element != null) {
                throw new IllegalStateException();
            }
            this.element = (Element)Objects.requireNonNull(this.buildUnsafe());
            this.buildChildren();
            return this.element;
        }

        @Nonnull
        protected abstract BuiltElement buildUnsafe();

        protected void buildChildren() {
        }

        @Nonnull
        public final BuiltElement getElement() {
            return (BuiltElement)((Element)Objects.requireNonNull(this.element));
        }
    }
}

