/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.reference;

import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.order.OrderByMemberReferencePath;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.AssociationEndSignature;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.ParameterizedProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.source.ClassifierWithSourceCode;
import cool.klass.model.meta.domain.api.source.EnumerationWithSourceCode;
import cool.klass.model.meta.domain.api.source.KlassWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.AssociationEndSignatureWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.AssociationEndWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.EnumerationPropertyWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.ParameterizedPropertyWithSourceCode;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.ThisMemberReferencePath;
import cool.klass.model.meta.domain.reference.DomainModelReferences;
import cool.klass.model.meta.domain.reference.DomainModelReferencesExpressionValueVisitor;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;

public class DomainModelReferencesPropertyVisitor
implements PropertyVisitor {
    @Nonnull
    private final DomainModelReferences domainModelReferences;

    public DomainModelReferencesPropertyVisitor(@Nonnull DomainModelReferences domainModelReferences) {
        this.domainModelReferences = Objects.requireNonNull(domainModelReferences);
    }

    public void visitPrimitiveProperty(PrimitiveProperty primitiveProperty) {
    }

    public void visitEnumerationProperty(EnumerationProperty enumerationProperty) {
        EnumerationPropertyWithSourceCode elementWithSourceCode = (EnumerationPropertyWithSourceCode)enumerationProperty;
        KlassParser.EnumerationPropertyContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.EnumerationReferenceContext reference = elementContext.enumerationReference();
        EnumerationWithSourceCode enumeration = elementWithSourceCode.getType();
        this.domainModelReferences.addEnumerationReference(reference, enumeration);
    }

    public void visitAssociationEnd(AssociationEnd associationEnd) {
        AssociationEndWithSourceCode elementWithSourceCode = (AssociationEndWithSourceCode)associationEnd;
        KlassParser.AssociationEndContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ClassReferenceContext reference = elementContext.classReference();
        KlassWithSourceCode klass = elementWithSourceCode.getType();
        this.domainModelReferences.addClassReference(reference, klass);
        associationEnd.getOrderBy().ifPresent(this::visitOrderBy);
    }

    public void visitAssociationEndSignature(AssociationEndSignature associationEndSignature) {
        AssociationEndSignatureWithSourceCode elementWithSourceCode = (AssociationEndSignatureWithSourceCode)associationEndSignature;
        KlassParser.AssociationEndSignatureContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ClassifierReferenceContext reference = elementContext.classifierReference();
        ClassifierWithSourceCode classifier = elementWithSourceCode.getType();
        this.domainModelReferences.addClassifierReference(reference, classifier);
        associationEndSignature.getOrderBy().ifPresent(this::visitOrderBy);
    }

    public void visitParameterizedProperty(ParameterizedProperty parameterizedProperty) {
        ParameterizedPropertyWithSourceCode elementWithSourceCode = (ParameterizedPropertyWithSourceCode)parameterizedProperty;
        KlassParser.ParameterizedPropertyContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ClassReferenceContext reference = elementContext.classReference();
        KlassWithSourceCode klass = elementWithSourceCode.getType();
        this.domainModelReferences.addClassReference(reference, klass);
        parameterizedProperty.getOrderBy().ifPresent(this::visitOrderBy);
    }

    public void visitOrderBy(OrderBy orderBy) {
        ImmutableList orderByMemberReferencePaths = orderBy.getOrderByMemberReferencePaths();
        for (OrderByMemberReferencePath orderByMemberReferencePath : orderByMemberReferencePaths) {
            ThisMemberReferencePath thisMemberReferencePath = orderByMemberReferencePath.getThisMemberReferencePath();
            thisMemberReferencePath.visit((ExpressionValueVisitor)new DomainModelReferencesExpressionValueVisitor(this.domainModelReferences));
        }
    }
}

