/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain;

import cool.klass.model.converter.compiler.token.categories.TokenCategory;
import cool.klass.model.converter.compiler.token.categorizing.lexer.LexerBasedTokenCategorizer;
import cool.klass.model.converter.compiler.token.categorizing.parser.ParserBasedTokenCategorizer;
import cool.klass.model.meta.domain.AbstractClassifier;
import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.AssociationImpl;
import cool.klass.model.meta.domain.EnumerationImpl;
import cool.klass.model.meta.domain.InterfaceImpl;
import cool.klass.model.meta.domain.KlassImpl;
import cool.klass.model.meta.domain.SourceCodeImpl;
import cool.klass.model.meta.domain.api.Association;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.TopLevelElement;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.domain.api.source.ElementWithSourceCode;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.domain.api.source.TopLevelElementWithSourceCode;
import cool.klass.model.meta.domain.projection.AbstractProjectionParent;
import cool.klass.model.meta.domain.projection.ProjectionImpl;
import cool.klass.model.meta.domain.reference.DomainModelDeclarations;
import cool.klass.model.meta.domain.reference.DomainModelDeclarationsTopLevelElementVisitor;
import cool.klass.model.meta.domain.reference.DomainModelReferences;
import cool.klass.model.meta.domain.reference.DomainModelReferencesTopLevelElementVisitor;
import cool.klass.model.meta.domain.service.ServiceGroupImpl;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public final class DomainModelImpl
implements DomainModelWithSourceCode {
    @Nonnull
    private final ImmutableList<SourceCode> sourceCodes;
    @Nonnull
    private final MapIterable<Token, TokenCategory> tokenCategoriesFromLexer;
    @Nonnull
    private final MapIterable<Token, TokenCategory> tokenCategoriesFromParser;
    @Nonnull
    private final DomainModelDeclarations domainModelDeclarations;
    @Nonnull
    private final DomainModelReferences domainModelReferences;
    @Nonnull
    private final ImmutableList<TopLevelElement> topLevelElements;
    @Nonnull
    private final ImmutableList<Enumeration> enumerations;
    @Nonnull
    private final ImmutableList<Classifier> classifiers;
    @Nonnull
    private final ImmutableList<Interface> interfaces;
    @Nonnull
    private final ImmutableList<Klass> classes;
    @Nonnull
    private final ImmutableList<Association> associations;
    @Nonnull
    private final ImmutableList<Projection> projections;
    @Nonnull
    private final ImmutableList<ServiceGroup> serviceGroups;
    @Nonnull
    private final Optional<Klass> userClass;
    private final ImmutableMap<String, TopLevelElement> topLevelElementsByName;
    private final ImmutableMap<String, Enumeration> enumerationsByName;
    private final ImmutableMap<String, Interface> interfacesByName;
    private final ImmutableMap<String, Klass> classesByName;
    private final ImmutableMap<String, Association> associationsByName;
    private final ImmutableMap<String, Projection> projectionsByName;
    private final ImmutableMap<Klass, ServiceGroup> serviceGroupsByKlass;
    private final ImmutableMap<String, Classifier> classifiersByName;

    private DomainModelImpl(@Nonnull ImmutableList<SourceCode> sourceCodes, @Nonnull MapIterable<Token, TokenCategory> tokenCategoriesFromLexer, @Nonnull MapIterable<Token, TokenCategory> tokenCategoriesFromParser, @Nonnull DomainModelDeclarations domainModelDeclarations, @Nonnull DomainModelReferences domainModelReferences, @Nonnull ImmutableList<TopLevelElement> topLevelElements, @Nonnull ImmutableList<Enumeration> enumerations, @Nonnull ImmutableList<Classifier> classifiers, @Nonnull ImmutableList<Interface> interfaces, @Nonnull ImmutableList<Klass> classes, @Nonnull ImmutableList<Association> associations, @Nonnull ImmutableList<Projection> projections, @Nonnull ImmutableList<ServiceGroup> serviceGroups) {
        this.sourceCodes = Objects.requireNonNull(sourceCodes);
        this.tokenCategoriesFromLexer = Objects.requireNonNull(tokenCategoriesFromLexer);
        this.tokenCategoriesFromParser = Objects.requireNonNull(tokenCategoriesFromParser);
        this.domainModelDeclarations = Objects.requireNonNull(domainModelDeclarations);
        this.domainModelReferences = Objects.requireNonNull(domainModelReferences);
        this.topLevelElements = Objects.requireNonNull(topLevelElements);
        this.enumerations = Objects.requireNonNull(enumerations);
        this.classifiers = Objects.requireNonNull(classifiers);
        this.interfaces = Objects.requireNonNull(interfaces);
        this.classes = Objects.requireNonNull(classes);
        this.associations = Objects.requireNonNull(associations);
        this.projections = Objects.requireNonNull(projections);
        this.serviceGroups = Objects.requireNonNull(serviceGroups);
        this.userClass = this.classes.detectOptional(Klass::isUser);
        this.topLevelElementsByName = this.topLevelElements.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.enumerationsByName = this.enumerations.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.classifiersByName = this.classifiers.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.interfacesByName = this.interfaces.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.classesByName = this.classes.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.associationsByName = this.associations.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.projectionsByName = this.projections.groupByUniqueKey(NamedElement::getName).toImmutable();
        this.serviceGroupsByKlass = this.serviceGroups.groupByUniqueKey(ServiceGroup::getKlass).toImmutable();
    }

    public ImmutableList<SourceCode> getSourceCodes() {
        return this.sourceCodes;
    }

    public Optional<TokenCategory> getTokenCategory(Token token) {
        TokenCategory lexerCategory = (TokenCategory)this.tokenCategoriesFromLexer.get((Object)token);
        TokenCategory parserCategory = (TokenCategory)this.tokenCategoriesFromParser.get((Object)token);
        if (lexerCategory != null && parserCategory != null) {
            throw new AssertionError(token);
        }
        if (lexerCategory != null) {
            return Optional.of(lexerCategory);
        }
        if (parserCategory != null) {
            return Optional.of(parserCategory);
        }
        return Optional.empty();
    }

    @Nonnull
    public MapIterable<Token, TokenCategory> getTokenCategoriesFromLexer() {
        return this.tokenCategoriesFromLexer;
    }

    @Nonnull
    public MapIterable<Token, TokenCategory> getTokenCategoriesFromParser() {
        return this.tokenCategoriesFromParser;
    }

    @Nonnull
    public Optional<ElementWithSourceCode> getElementByDeclaration(Token token) {
        return this.domainModelDeclarations.getElementByDeclaration(token);
    }

    @Nonnull
    public Optional<ElementWithSourceCode> getElementByReference(Token token) {
        return this.domainModelReferences.getElementByReference(token);
    }

    @Nonnull
    public DomainModelReferences getDomainModelReferences() {
        return this.domainModelReferences;
    }

    public Optional<Klass> getUserClass() {
        return this.userClass;
    }

    @Nonnull
    public ImmutableList<TopLevelElement> getTopLevelElements() {
        return this.topLevelElements;
    }

    @Nonnull
    public ImmutableList<Enumeration> getEnumerations() {
        return this.enumerations;
    }

    @Nonnull
    public ImmutableList<Classifier> getClassifiers() {
        return this.classifiers;
    }

    @Nonnull
    public ImmutableList<Interface> getInterfaces() {
        return this.interfaces;
    }

    @Nonnull
    public ImmutableList<Klass> getClasses() {
        return this.classes;
    }

    @Nonnull
    public ImmutableList<Association> getAssociations() {
        return this.associations;
    }

    @Nonnull
    public ImmutableList<Projection> getProjections() {
        return this.projections;
    }

    @Nonnull
    public ImmutableList<ServiceGroup> getServiceGroups() {
        return this.serviceGroups;
    }

    public TopLevelElementWithSourceCode getTopLevelElementByName(String name) {
        return (TopLevelElementWithSourceCode)this.topLevelElementsByName.get((Object)name);
    }

    public Enumeration getEnumerationByName(String name) {
        return (Enumeration)this.enumerationsByName.get((Object)name);
    }

    public Classifier getClassifierByName(String name) {
        return (Classifier)this.classifiersByName.get((Object)name);
    }

    public Interface getInterfaceByName(String name) {
        return (Interface)this.interfacesByName.get((Object)name);
    }

    public Klass getClassByName(String name) {
        return (Klass)this.classesByName.get((Object)name);
    }

    public Association getAssociationByName(String name) {
        return (Association)this.associationsByName.get((Object)name);
    }

    public Projection getProjectionByName(String name) {
        return (Projection)this.projectionsByName.get((Object)name);
    }

    public static final class DomainModelBuilder {
        @Nonnull
        private final ImmutableList<SourceCodeImpl.SourceCodeBuilderImpl> sourceCodeBuilders;
        @Nonnull
        private final ImmutableList<TopLevelElement.TopLevelElementBuilder> topLevelElementBuilders;
        @Nonnull
        private final ImmutableList<EnumerationImpl.EnumerationBuilder> enumerationBuilders;
        @Nonnull
        private final ImmutableList<AbstractClassifier.ClassifierBuilder<?>> classifierBuilders;
        @Nonnull
        private final ImmutableList<InterfaceImpl.InterfaceBuilder> interfaceBuilders;
        @Nonnull
        private final ImmutableList<KlassImpl.KlassBuilder> classBuilders;
        @Nonnull
        private final ImmutableList<AssociationImpl.AssociationBuilder> associationBuilders;
        @Nonnull
        private final ImmutableList<ProjectionImpl.ProjectionBuilder> projectionBuilders;
        @Nonnull
        private final ImmutableList<ServiceGroupImpl.ServiceGroupBuilder> serviceGroupBuilders;

        public DomainModelBuilder(@Nonnull ImmutableList<SourceCodeImpl.SourceCodeBuilderImpl> sourceCodeBuilders, @Nonnull ImmutableList<TopLevelElement.TopLevelElementBuilder> topLevelElementBuilders, @Nonnull ImmutableList<EnumerationImpl.EnumerationBuilder> enumerationBuilders, @Nonnull ImmutableList<AbstractClassifier.ClassifierBuilder<?>> classifierBuilders, @Nonnull ImmutableList<InterfaceImpl.InterfaceBuilder> interfaceBuilders, @Nonnull ImmutableList<KlassImpl.KlassBuilder> classBuilders, @Nonnull ImmutableList<AssociationImpl.AssociationBuilder> associationBuilders, @Nonnull ImmutableList<ProjectionImpl.ProjectionBuilder> projectionBuilders, @Nonnull ImmutableList<ServiceGroupImpl.ServiceGroupBuilder> serviceGroupBuilders) {
            this.sourceCodeBuilders = Objects.requireNonNull(sourceCodeBuilders);
            this.topLevelElementBuilders = Objects.requireNonNull(topLevelElementBuilders);
            this.enumerationBuilders = Objects.requireNonNull(enumerationBuilders);
            this.classifierBuilders = Objects.requireNonNull(classifierBuilders);
            this.interfaceBuilders = Objects.requireNonNull(interfaceBuilders);
            this.classBuilders = Objects.requireNonNull(classBuilders);
            this.associationBuilders = Objects.requireNonNull(associationBuilders);
            this.projectionBuilders = Objects.requireNonNull(projectionBuilders);
            this.serviceGroupBuilders = Objects.requireNonNull(serviceGroupBuilders);
        }

        @Nonnull
        public DomainModelImpl build() {
            ImmutableList sourceCodes = this.sourceCodeBuilders.collect(SourceCodeImpl.SourceCodeBuilderImpl::build).toImmutable();
            ImmutableList enumerations = this.enumerationBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            ImmutableList interfaces = this.interfaceBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            ImmutableList classes = this.classBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            ImmutableList classifiers = this.classifierBuilders.collect(AbstractElement.ElementBuilder::getElement);
            ImmutableList associations = this.associationBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            this.interfaceBuilders.each(AbstractClassifier.ClassifierBuilder::build2);
            this.classBuilders.each(KlassImpl.KlassBuilder::build2);
            this.interfaceBuilders.each(AbstractClassifier.ClassifierBuilder::build3);
            this.classBuilders.each(AbstractClassifier.ClassifierBuilder::build3);
            ImmutableList projections = this.projectionBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            this.projectionBuilders.each(AbstractProjectionParent.AbstractProjectionParentBuilder::build2);
            ImmutableList serviceGroups = this.serviceGroupBuilders.collect(AbstractElement.ElementBuilder::build).toImmutable();
            ImmutableList topLevelElements = this.topLevelElementBuilders.collect(TopLevelElement.TopLevelElementBuilder::getElement);
            MapIterable<Token, TokenCategory> tokenCategoriesFromLexer = this.getTokenCategoriesFromLexer((ImmutableList<SourceCode>)sourceCodes);
            MapIterable<Token, TokenCategory> tokenCategoriesFromParser = this.getTokenCategoriesFromParser((ImmutableList<SourceCode>)sourceCodes);
            ImmutableList duplicateTokens = tokenCategoriesFromLexer.keysView().select(arg_0 -> tokenCategoriesFromParser.containsKey(arg_0)).toImmutableList();
            if (duplicateTokens.notEmpty()) {
                throw new AssertionError(duplicateTokens);
            }
            DomainModelDeclarations domainModelDeclarations = this.getDomainModelDeclarations((ImmutableList<TopLevelElement>)topLevelElements);
            DomainModelReferences domainModelReferences = this.getDomainModelReferences((ImmutableList<TopLevelElement>)topLevelElements);
            this.sourceCodeBuilders.forEach(SourceCodeImpl.SourceCodeBuilderImpl::build2);
            return new DomainModelImpl((ImmutableList<SourceCode>)sourceCodes, tokenCategoriesFromLexer, tokenCategoriesFromParser, domainModelDeclarations, domainModelReferences, (ImmutableList<TopLevelElement>)topLevelElements, (ImmutableList<Enumeration>)enumerations, (ImmutableList<Classifier>)classifiers, (ImmutableList<Interface>)interfaces, (ImmutableList<Klass>)classes, (ImmutableList<Association>)associations, (ImmutableList<Projection>)projections, (ImmutableList<ServiceGroup>)serviceGroups);
        }

        private MapIterable<Token, TokenCategory> getTokenCategoriesFromLexer(ImmutableList<SourceCode> sourceCodes) {
            MutableOrderedMap tokenCategoriesFromLexer = OrderedMapAdapter.adapt(new LinkedHashMap());
            sourceCodes.collect(SourceCode::getTokenStream).forEachWith(LexerBasedTokenCategorizer::findTokenCategoriesFromLexer, (Object)tokenCategoriesFromLexer);
            return tokenCategoriesFromLexer.asUnmodifiable();
        }

        private MapIterable<Token, TokenCategory> getTokenCategoriesFromParser(ImmutableList<SourceCode> sourceCodes) {
            ParserBasedTokenCategorizer listener = new ParserBasedTokenCategorizer();
            sourceCodes.collect(SourceCode::getParserContext).forEachWith(ParserBasedTokenCategorizer::findTokenCategoriesFromParser, (Object)listener);
            return listener.getTokenCategories();
        }

        private DomainModelDeclarations getDomainModelDeclarations(ImmutableList<TopLevelElement> topLevelElements) {
            DomainModelDeclarations domainModelDeclarations = new DomainModelDeclarations();
            for (TopLevelElement topLevelElement : topLevelElements) {
                topLevelElement.visit((TopLevelElementVisitor)new DomainModelDeclarationsTopLevelElementVisitor(domainModelDeclarations));
            }
            return domainModelDeclarations;
        }

        private DomainModelReferences getDomainModelReferences(ImmutableList<TopLevelElement> topLevelElements) {
            DomainModelReferences domainModelReferences = new DomainModelReferences();
            for (TopLevelElement topLevelElement : topLevelElements) {
                topLevelElement.visit((TopLevelElementVisitor)new DomainModelReferencesTopLevelElementVisitor(domainModelReferences));
            }
            return domainModelReferences;
        }
    }
}

