/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.reference;

import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.AssociationEndSignature;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.ParameterizedProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.source.property.AssociationEndSignatureWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.AssociationEndWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.EnumerationPropertyWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.ParameterizedPropertyWithSourceCode;
import cool.klass.model.meta.domain.api.source.property.PrimitivePropertyWithSourceCode;
import cool.klass.model.meta.domain.reference.DomainModelDeclarations;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DomainModelDeclarationsPropertyVisitor
implements PropertyVisitor {
    @Nonnull
    private final DomainModelDeclarations domainModelDeclarations;

    public DomainModelDeclarationsPropertyVisitor(@Nonnull DomainModelDeclarations domainModelDeclarations) {
        this.domainModelDeclarations = Objects.requireNonNull(domainModelDeclarations);
    }

    public void visitPrimitiveProperty(PrimitiveProperty primitiveProperty) {
        PrimitivePropertyWithSourceCode element = (PrimitivePropertyWithSourceCode)primitiveProperty;
        KlassParser.PrimitivePropertyContext declaration = element.getElementContext();
        this.domainModelDeclarations.addPrimitivePropertyDeclaration(declaration, element);
    }

    public void visitEnumerationProperty(EnumerationProperty enumerationProperty) {
        EnumerationPropertyWithSourceCode element = (EnumerationPropertyWithSourceCode)enumerationProperty;
        KlassParser.EnumerationPropertyContext declaration = element.getElementContext();
        this.domainModelDeclarations.addEnumerationPropertyDeclaration(declaration, element);
    }

    public void visitAssociationEnd(AssociationEnd associationEnd) {
        AssociationEndWithSourceCode element = (AssociationEndWithSourceCode)associationEnd;
        KlassParser.AssociationEndContext declaration = element.getElementContext();
        this.domainModelDeclarations.addAssociationEndDeclaration(declaration, element);
    }

    public void visitAssociationEndSignature(AssociationEndSignature associationEndSignature) {
        AssociationEndSignatureWithSourceCode element = (AssociationEndSignatureWithSourceCode)associationEndSignature;
        KlassParser.AssociationEndSignatureContext declaration = element.getElementContext();
        this.domainModelDeclarations.addAssociationEndSignatureDeclaration(declaration, element);
    }

    public void visitParameterizedProperty(ParameterizedProperty parameterizedProperty) {
        ParameterizedPropertyWithSourceCode element = (ParameterizedPropertyWithSourceCode)parameterizedProperty;
        KlassParser.ParameterizedPropertyContext declaration = element.getElementContext();
        this.domainModelDeclarations.addParameterizedPropertyDeclaration(declaration, element);
    }
}

