/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.reference;

import cool.klass.model.meta.domain.api.Association;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.EnumerationLiteral;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import cool.klass.model.meta.domain.api.source.AssociationWithSourceCode;
import cool.klass.model.meta.domain.api.source.EnumerationLiteralWithSourceCode;
import cool.klass.model.meta.domain.api.source.EnumerationWithSourceCode;
import cool.klass.model.meta.domain.api.source.InterfaceWithSourceCode;
import cool.klass.model.meta.domain.api.source.KlassWithSourceCode;
import cool.klass.model.meta.domain.api.source.projection.ProjectionWithSourceCode;
import cool.klass.model.meta.domain.api.source.service.ServiceGroupWithSourceCode;
import cool.klass.model.meta.domain.reference.DomainModelDeclarations;
import cool.klass.model.meta.domain.reference.DomainModelDeclarationsPropertyVisitor;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;

public class DomainModelDeclarationsTopLevelElementVisitor
implements TopLevelElementVisitor {
    @Nonnull
    private final DomainModelDeclarations domainModelDeclarations;

    public DomainModelDeclarationsTopLevelElementVisitor(@Nonnull DomainModelDeclarations domainModelDeclarations) {
        this.domainModelDeclarations = Objects.requireNonNull(domainModelDeclarations);
    }

    public void visitEnumeration(Enumeration enumeration) {
        EnumerationWithSourceCode element = (EnumerationWithSourceCode)enumeration;
        KlassParser.EnumerationDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addEnumerationDeclaration(declaration, element);
        for (EnumerationLiteral enumerationLiteral : enumeration.getEnumerationLiterals()) {
            this.visitEnumerationLiteral(enumerationLiteral);
        }
    }

    private void visitEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
        EnumerationLiteralWithSourceCode element = (EnumerationLiteralWithSourceCode)enumerationLiteral;
        KlassParser.EnumerationLiteralContext declaration = element.getElementContext();
        this.domainModelDeclarations.addEnumerationLiteralDeclaration(declaration, element);
    }

    public void visitInterface(Interface anInterface) {
        InterfaceWithSourceCode element = (InterfaceWithSourceCode)anInterface;
        KlassParser.InterfaceDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addInterfaceDeclaration(declaration, element);
        this.visitClassifier((Classifier)anInterface);
    }

    public void visitKlass(Klass klass) {
        KlassWithSourceCode element = (KlassWithSourceCode)klass;
        KlassParser.ClassDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addKlassDeclaration(declaration, element);
        this.visitClassifier((Classifier)klass);
    }

    private void visitClassifier(Classifier classifier) {
        ImmutableList properties = classifier.getDeclaredProperties();
        for (Property property : properties) {
            property.visit((PropertyVisitor)new DomainModelDeclarationsPropertyVisitor(this.domainModelDeclarations));
        }
    }

    public void visitAssociation(Association association) {
        AssociationWithSourceCode element = (AssociationWithSourceCode)association;
        KlassParser.AssociationDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addAssociationDeclaration(declaration, element);
    }

    public void visitProjection(Projection projection) {
        ProjectionWithSourceCode element = (ProjectionWithSourceCode)projection;
        KlassParser.ProjectionDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addProjectionDeclaration(declaration, element);
    }

    public void visitServiceGroup(ServiceGroup serviceGroup) {
        ServiceGroupWithSourceCode element = (ServiceGroupWithSourceCode)serviceGroup;
        KlassParser.ServiceGroupDeclarationContext declaration = element.getElementContext();
        this.domainModelDeclarations.addServiceGroupDeclaration(declaration, element);
    }
}

