/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.reference;

import cool.klass.model.meta.domain.api.Association;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.Interface;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.TopLevelElementVisitor;
import cool.klass.model.meta.domain.api.criteria.Criteria;
import cool.klass.model.meta.domain.api.criteria.CriteriaVisitor;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.order.OrderByMemberReferencePath;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.projection.ProjectionChild;
import cool.klass.model.meta.domain.api.projection.ProjectionVisitor;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.service.Service;
import cool.klass.model.meta.domain.api.service.ServiceGroup;
import cool.klass.model.meta.domain.api.service.ServiceProjectionDispatch;
import cool.klass.model.meta.domain.api.service.url.Url;
import cool.klass.model.meta.domain.api.source.ClassifierWithSourceCode;
import cool.klass.model.meta.domain.api.source.KlassWithSourceCode;
import cool.klass.model.meta.domain.api.source.projection.ProjectionWithSourceCode;
import cool.klass.model.meta.domain.api.source.service.ServiceGroupWithSourceCode;
import cool.klass.model.meta.domain.api.source.service.ServiceProjectionDispatchWithSourceCode;
import cool.klass.model.meta.domain.api.value.ExpressionValueVisitor;
import cool.klass.model.meta.domain.api.value.ThisMemberReferencePath;
import cool.klass.model.meta.domain.reference.DomainModelReferences;
import cool.klass.model.meta.domain.reference.DomainModelReferencesCriteriaVisitor;
import cool.klass.model.meta.domain.reference.DomainModelReferencesExpressionValueVisitor;
import cool.klass.model.meta.domain.reference.DomainModelReferencesProjectionVisitor;
import cool.klass.model.meta.domain.reference.DomainModelReferencesPropertyVisitor;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.ImmutableList;

public class DomainModelReferencesTopLevelElementVisitor
implements TopLevelElementVisitor {
    @Nonnull
    private final DomainModelReferences domainModelReferences;

    public DomainModelReferencesTopLevelElementVisitor(@Nonnull DomainModelReferences domainModelReferences) {
        this.domainModelReferences = Objects.requireNonNull(domainModelReferences);
    }

    public void visitEnumeration(@Nonnull Enumeration enumeration) {
    }

    public void visitInterface(@Nonnull Interface anInterface) {
        this.visitClassifier((Classifier)anInterface);
    }

    public void visitKlass(@Nonnull Klass klass) {
        this.visitClassifier((Classifier)klass);
    }

    private void visitClassifier(@Nonnull Classifier classifier) {
        ImmutableList properties = classifier.getDeclaredProperties();
        for (Property property : properties) {
            property.visit((PropertyVisitor)new DomainModelReferencesPropertyVisitor(this.domainModelReferences));
        }
    }

    public void visitAssociation(@Nonnull Association association) {
        Criteria criteria = association.getCriteria();
        this.visitCriteria(criteria);
    }

    public void visitProjection(@Nonnull Projection projection) {
        ProjectionWithSourceCode elementWithSourceCode = (ProjectionWithSourceCode)projection;
        KlassParser.ProjectionDeclarationContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ClassifierReferenceContext reference = elementContext.classifierReference();
        ClassifierWithSourceCode classifier = elementWithSourceCode.getClassifier();
        this.domainModelReferences.addClassifierReference(reference, classifier);
        for (ProjectionChild projectionChild : projection.getChildren()) {
            projectionChild.visit((ProjectionVisitor)new DomainModelReferencesProjectionVisitor(this.domainModelReferences));
        }
    }

    public void visitServiceGroup(@Nonnull ServiceGroup serviceGroup) {
        ServiceGroupWithSourceCode elementWithSourceCode = (ServiceGroupWithSourceCode)serviceGroup;
        KlassParser.ServiceGroupDeclarationContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ClassReferenceContext reference = elementContext.classReference();
        KlassWithSourceCode klass = elementWithSourceCode.getKlass();
        this.domainModelReferences.addClassReference(reference, klass);
        for (Url url : serviceGroup.getUrls()) {
            this.visitUrl(url);
        }
    }

    public void visitUrl(@Nonnull Url url) {
        ImmutableList services = url.getServices();
        for (Service service : services) {
            this.visitService(service);
        }
    }

    public void visitService(@Nonnull Service service) {
        service.getQueryCriteria().ifPresent(this::visitCriteria);
        service.getAuthorizeCriteria().ifPresent(this::visitCriteria);
        service.getValidateCriteria().ifPresent(this::visitCriteria);
        service.getConflictCriteria().ifPresent(this::visitCriteria);
        service.getProjectionDispatch().ifPresent(this::visitProjectionDispatch);
        service.getOrderBy().ifPresent(this::visitOrderBy);
    }

    public void visitCriteria(Criteria criteria) {
        criteria.visit((CriteriaVisitor)new DomainModelReferencesCriteriaVisitor(this.domainModelReferences));
    }

    public void visitProjectionDispatch(ServiceProjectionDispatch serviceProjectionDispatch) {
        ServiceProjectionDispatchWithSourceCode elementWithSourceCode = (ServiceProjectionDispatchWithSourceCode)serviceProjectionDispatch;
        KlassParser.ServiceProjectionDispatchContext elementContext = elementWithSourceCode.getElementContext();
        KlassParser.ProjectionReferenceContext reference = elementContext.projectionReference();
        ProjectionWithSourceCode projection = elementWithSourceCode.getProjection();
        this.domainModelReferences.addProjectionReference(reference, projection);
    }

    public void visitOrderBy(OrderBy orderBy) {
        ImmutableList orderByMemberReferencePaths = orderBy.getOrderByMemberReferencePaths();
        for (OrderByMemberReferencePath orderByMemberReferencePath : orderByMemberReferencePaths) {
            ThisMemberReferencePath thisMemberReferencePath = orderByMemberReferencePath.getThisMemberReferencePath();
            thisMemberReferencePath.visit((ExpressionValueVisitor)new DomainModelReferencesExpressionValueVisitor(this.domainModelReferences));
        }
    }
}

