/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain.service;

import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.criteria.Criteria;
import cool.klass.model.meta.domain.api.order.OrderBy;
import cool.klass.model.meta.domain.api.service.Service;
import cool.klass.model.meta.domain.api.service.ServiceMultiplicity;
import cool.klass.model.meta.domain.api.service.ServiceProjectionDispatch;
import cool.klass.model.meta.domain.api.service.Verb;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.domain.criteria.AbstractCriteria;
import cool.klass.model.meta.domain.order.OrderByImpl;
import cool.klass.model.meta.domain.service.ServiceProjectionDispatchImpl;
import cool.klass.model.meta.domain.service.url.UrlImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;

public final class ServiceImpl
extends AbstractElement
implements Service {
    @Nonnull
    private final UrlImpl url;
    @Nonnull
    private final Verb verb;
    @Nonnull
    private final ServiceMultiplicity serviceMultiplicity;
    private Optional<Criteria> queryCriteria;
    private Optional<Criteria> authorizeCriteria;
    private Optional<Criteria> validateCriteria;
    private Optional<Criteria> conflictCriteria;
    private Optional<ServiceProjectionDispatch> projectionDispatch;
    @Nonnull
    private Optional<OrderBy> orderBy = Optional.empty();

    private ServiceImpl(@Nonnull KlassParser.ServiceDeclarationContext elementContext, @Nonnull Optional<Element> macroElement, @Nullable SourceCode sourceCode, @Nonnull UrlImpl url, @Nonnull Verb verb, @Nonnull ServiceMultiplicity serviceMultiplicity) {
        super((ParserRuleContext)elementContext, macroElement, sourceCode);
        this.url = Objects.requireNonNull(url);
        this.verb = Objects.requireNonNull(verb);
        this.serviceMultiplicity = Objects.requireNonNull(serviceMultiplicity);
    }

    @Nonnull
    public KlassParser.ServiceDeclarationContext getElementContext() {
        return (KlassParser.ServiceDeclarationContext)super.getElementContext();
    }

    @Nonnull
    public UrlImpl getUrl() {
        return this.url;
    }

    @Nonnull
    public Verb getVerb() {
        return this.verb;
    }

    @Nonnull
    public ServiceMultiplicity getServiceMultiplicity() {
        return this.serviceMultiplicity;
    }

    @Nonnull
    public Optional<Criteria> getQueryCriteria() {
        return this.queryCriteria;
    }

    private void setQueryCriteria(@Nonnull Optional<Criteria> queryCriteria) {
        if (this.queryCriteria != null) {
            throw new IllegalStateException();
        }
        this.queryCriteria = Objects.requireNonNull(queryCriteria);
    }

    @Nonnull
    public Optional<Criteria> getAuthorizeCriteria() {
        return this.authorizeCriteria;
    }

    private void setAuthorizeCriteria(@Nonnull Optional<Criteria> authorizeCriteria) {
        if (this.authorizeCriteria != null) {
            throw new IllegalStateException();
        }
        this.authorizeCriteria = Objects.requireNonNull(authorizeCriteria);
    }

    @Nonnull
    public Optional<Criteria> getValidateCriteria() {
        return this.validateCriteria;
    }

    private void setValidateCriteria(@Nonnull Optional<Criteria> validateCriteria) {
        if (this.validateCriteria != null) {
            throw new IllegalStateException();
        }
        this.validateCriteria = Objects.requireNonNull(validateCriteria);
    }

    @Nonnull
    public Optional<Criteria> getConflictCriteria() {
        return this.conflictCriteria;
    }

    private void setConflictCriteria(@Nonnull Optional<Criteria> conflictCriteria) {
        if (this.conflictCriteria != null) {
            throw new IllegalStateException();
        }
        this.conflictCriteria = Objects.requireNonNull(conflictCriteria);
    }

    public Optional<ServiceProjectionDispatch> getProjectionDispatch() {
        return Objects.requireNonNull(this.projectionDispatch);
    }

    private void setProjectionDispatch(Optional<ServiceProjectionDispatch> projectionDispatch) {
        if (this.projectionDispatch != null) {
            throw new IllegalStateException();
        }
        this.projectionDispatch = Objects.requireNonNull(projectionDispatch);
    }

    @Nonnull
    public Optional<OrderBy> getOrderBy() {
        return Objects.requireNonNull(this.orderBy);
    }

    private void setOrderBy(@Nonnull Optional<OrderBy> orderBy) {
        this.orderBy = Objects.requireNonNull(orderBy);
    }

    public int getNumParameters() {
        int numUrlParameters = this.url.getParameters().size();
        int numVersionParameters = this.isVersionClauseRequired() ? 1 : 0;
        int numAuthorizeParameters = this.isAuthorizeClauseRequired() ? 1 : 0;
        return numUrlParameters + numVersionParameters + numAuthorizeParameters;
    }

    public boolean isVersionClauseRequired() {
        return this.serviceMultiplicity == ServiceMultiplicity.ONE && this.url.getServiceGroup().getKlass().getVersionProperty().isPresent();
    }

    public boolean isAuthorizeClauseRequired() {
        return this.authorizeCriteria.isPresent();
    }

    public static final class ServiceBuilder
    extends AbstractElement.ElementBuilder<ServiceImpl> {
        @Nonnull
        private final UrlImpl.UrlBuilder urlBuilder;
        @Nonnull
        private final Verb verb;
        @Nonnull
        private final ServiceMultiplicity serviceMultiplicity;
        private Optional<ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder> projectionDispatchBuilder;
        @Nonnull
        private Optional<OrderByImpl.OrderByBuilder> orderByBuilder = Optional.empty();
        private Optional<AbstractCriteria.AbstractCriteriaBuilder<?>> criteria = Optional.empty();
        private Optional<AbstractCriteria.AbstractCriteriaBuilder<?>> authorize = Optional.empty();
        private Optional<AbstractCriteria.AbstractCriteriaBuilder<?>> validate = Optional.empty();
        private Optional<AbstractCriteria.AbstractCriteriaBuilder<?>> conflict = Optional.empty();

        public ServiceBuilder(@Nonnull KlassParser.ServiceDeclarationContext elementContext, @Nonnull Optional<AbstractElement.ElementBuilder<?>> macroElement, @Nullable SourceCode.SourceCodeBuilder sourceCode, @Nonnull UrlImpl.UrlBuilder urlBuilder, @Nonnull Verb verb, @Nonnull ServiceMultiplicity serviceMultiplicity) {
            super((ParserRuleContext)elementContext, macroElement, sourceCode);
            this.urlBuilder = Objects.requireNonNull(urlBuilder);
            this.verb = Objects.requireNonNull(verb);
            this.serviceMultiplicity = Objects.requireNonNull(serviceMultiplicity);
        }

        public void addCriteriaBuilder(@Nonnull String criteriaKeyword, @Nonnull AbstractCriteria.AbstractCriteriaBuilder<?> criteriaBuilder) {
            Objects.requireNonNull(criteriaKeyword);
            Objects.requireNonNull(criteriaBuilder);
            switch (criteriaKeyword) {
                case "criteria": {
                    if (this.criteria.isPresent()) {
                        throw new IllegalStateException();
                    }
                    this.criteria = Optional.of(criteriaBuilder);
                    return;
                }
                case "authorize": {
                    if (this.authorize.isPresent()) {
                        throw new IllegalStateException();
                    }
                    this.authorize = Optional.of(criteriaBuilder);
                    return;
                }
                case "validate": {
                    if (this.validate.isPresent()) {
                        throw new IllegalStateException();
                    }
                    this.validate = Optional.of(criteriaBuilder);
                    return;
                }
                case "conflict": {
                    if (this.conflict.isPresent()) {
                        throw new IllegalStateException();
                    }
                    this.conflict = Optional.of(criteriaBuilder);
                    return;
                }
            }
            throw new AssertionError();
        }

        public void setProjectionDispatchBuilder(@Nonnull Optional<ServiceProjectionDispatchImpl.ServiceProjectionDispatchBuilder> projectionDispatchBuilder) {
            this.projectionDispatchBuilder = Objects.requireNonNull(projectionDispatchBuilder);
        }

        public void setOrderByBuilder(@Nonnull Optional<OrderByImpl.OrderByBuilder> orderByBuilder) {
            this.orderByBuilder = Objects.requireNonNull(orderByBuilder);
        }

        @Override
        @Nonnull
        protected ServiceImpl buildUnsafe() {
            ServiceImpl service = new ServiceImpl((KlassParser.ServiceDeclarationContext)this.elementContext, this.macroElement.map(AbstractElement.ElementBuilder::getElement), this.sourceCode.build(), (UrlImpl)this.urlBuilder.getElement(), this.verb, this.serviceMultiplicity);
            Optional<ServiceProjectionDispatch> projectionDispatch = this.projectionDispatchBuilder.map(AbstractElement.ElementBuilder::build);
            service.setProjectionDispatch(projectionDispatch);
            Optional<Criteria> queryCriteria = this.criteria.map(AbstractElement.ElementBuilder::build);
            Optional<Criteria> authorizeCriteria = this.authorize.map(AbstractElement.ElementBuilder::build);
            Optional<Criteria> validateCriteria = this.validate.map(AbstractElement.ElementBuilder::build);
            Optional<Criteria> conflictCriteria = this.conflict.map(AbstractElement.ElementBuilder::build);
            service.setQueryCriteria(queryCriteria);
            service.setAuthorizeCriteria(authorizeCriteria);
            service.setValidateCriteria(validateCriteria);
            service.setConflictCriteria(conflictCriteria);
            return service;
        }

        @Override
        protected void buildChildren() {
            Optional<OrderBy> orderBy = this.orderByBuilder.map(AbstractElement.ElementBuilder::build);
            ((ServiceImpl)this.element).setOrderBy(orderBy);
        }
    }
}

