/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain;

import cool.klass.model.meta.domain.AbstractClassifier;
import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.meta.domain.api.source.KlassWithSourceCode;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.domain.property.AssociationEndImpl;
import cool.klass.model.meta.grammar.KlassParser;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;

public final class KlassImpl
extends AbstractClassifier
implements KlassWithSourceCode {
    private final boolean isAbstract;
    private final boolean isUser;
    private final boolean isTransient;
    private ImmutableList<AssociationEnd> declaredAssociationEnds;
    private ImmutableMap<String, AssociationEnd> declaredAssociationEndsByName;
    private ImmutableList<AssociationEnd> associationEnds;
    private ImmutableMap<String, AssociationEnd> associationEndsByName;
    @Nonnull
    private Optional<AssociationEnd> versionProperty = Optional.empty();
    @Nonnull
    private Optional<AssociationEnd> versionedProperty = Optional.empty();
    private Optional<Klass> superClass;
    private ImmutableList<Klass> subClasses;

    private KlassImpl(@Nonnull KlassParser.ClassDeclarationContext elementContext, @Nonnull Optional<Element> macroElement, @Nullable SourceCode sourceCode, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull String packageName, boolean isAbstract, boolean isUser, boolean isTransient) {
        super((ParserRuleContext)elementContext, macroElement, sourceCode, ordinal, nameContext, packageName);
        this.isAbstract = isAbstract;
        this.isUser = isUser;
        this.isTransient = isTransient;
    }

    @Nonnull
    public KlassParser.ClassDeclarationContext getElementContext() {
        return (KlassParser.ClassDeclarationContext)super.getElementContext();
    }

    @Nonnull
    public Optional<AssociationEnd> getVersionProperty() {
        return this.versionProperty;
    }

    @Nonnull
    public Optional<AssociationEnd> getVersionedProperty() {
        return this.versionedProperty;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    private void setDeclaredAssociationEnds(ImmutableList<AssociationEnd> declaredAssociationEnds) {
        if (this.declaredAssociationEnds != null) {
            throw new IllegalStateException();
        }
        this.declaredAssociationEnds = Objects.requireNonNull(declaredAssociationEnds);
        this.declaredAssociationEndsByName = this.declaredAssociationEnds.groupByUniqueKey(NamedElement::getName);
    }

    public ImmutableList<AssociationEnd> getDeclaredAssociationEnds() {
        return Objects.requireNonNull(this.declaredAssociationEnds);
    }

    public AssociationEnd getDeclaredAssociationEndByName(String name) {
        return (AssociationEnd)this.declaredAssociationEndsByName.get((Object)name);
    }

    private void setAssociationEnds(ImmutableList<AssociationEnd> associationEnds) {
        if (this.associationEnds != null) {
            throw new IllegalStateException();
        }
        this.associationEnds = Objects.requireNonNull(associationEnds);
        this.associationEndsByName = this.associationEnds.groupByUniqueKey(NamedElement::getName);
        this.versionProperty = this.associationEnds.detectOptional(ReferenceProperty::isVersion);
        this.versionedProperty = this.associationEnds.detectOptional(AssociationEnd::isVersioned);
    }

    public ImmutableList<AssociationEnd> getAssociationEnds() {
        return Objects.requireNonNull(this.associationEnds);
    }

    public AssociationEnd getAssociationEndByName(String name) {
        return (AssociationEnd)this.associationEndsByName.get((Object)name);
    }

    @Nonnull
    public Optional<Klass> getSuperClass() {
        return this.superClass;
    }

    private void setSuperClass(Optional<Klass> superClass) {
        if (this.superClass != null) {
            throw new IllegalStateException();
        }
        this.superClass = Objects.requireNonNull(superClass);
    }

    public ImmutableList<Klass> getSubClasses() {
        return Objects.requireNonNull(this.subClasses);
    }

    public void setSubClasses(ImmutableList<Klass> subClasses) {
        if (this.subClasses != null) {
            throw new IllegalStateException();
        }
        this.subClasses = Objects.requireNonNull(subClasses);
    }

    public static final class KlassBuilder
    extends AbstractClassifier.ClassifierBuilder<KlassImpl> {
        private final boolean isAbstract;
        private final boolean isUser;
        private final boolean isTransient;
        @Nullable
        private ImmutableList<AssociationEndImpl.AssociationEndBuilder> declaredAssociationEnds;
        private Optional<KlassBuilder> superClass;
        private ImmutableList<KlassBuilder> subClasses;

        public KlassBuilder(@Nonnull KlassParser.ClassDeclarationContext elementContext, @Nonnull Optional<AbstractElement.ElementBuilder<?>> macroElement, @Nullable SourceCode.SourceCodeBuilder sourceCode, int ordinal, @Nonnull KlassParser.IdentifierContext nameContext, @Nonnull String packageName, boolean isAbstract, boolean isUser, boolean isTransient) {
            super((ParserRuleContext)elementContext, macroElement, sourceCode, ordinal, nameContext, packageName);
            this.isAbstract = isAbstract;
            this.isUser = isUser;
            this.isTransient = isTransient;
        }

        public void setDeclaredAssociationEnds(@Nonnull ImmutableList<AssociationEndImpl.AssociationEndBuilder> declaredAssociationEnds) {
            if (this.declaredAssociationEnds != null) {
                throw new IllegalStateException();
            }
            this.declaredAssociationEnds = Objects.requireNonNull(declaredAssociationEnds);
        }

        @Override
        @Nonnull
        protected KlassImpl buildUnsafe() {
            return new KlassImpl((KlassParser.ClassDeclarationContext)this.elementContext, this.macroElement.map(AbstractElement.ElementBuilder::getElement), this.sourceCode.build(), this.ordinal, this.getNameContext(), this.packageName, this.isAbstract, this.isUser, this.isTransient);
        }

        public void setSuperClass(@Nonnull Optional<KlassBuilder> superClass) {
            if (this.superClass != null) {
                throw new IllegalStateException();
            }
            this.superClass = Objects.requireNonNull(superClass);
        }

        public void setSubClassBuilders(ImmutableList<KlassBuilder> subClasses) {
            if (this.subClasses != null) {
                throw new IllegalStateException();
            }
            this.subClasses = Objects.requireNonNull(subClasses);
        }

        @Override
        public void build2() {
            super.build2();
            ImmutableList declaredAssociationEnds = this.declaredAssociationEnds.collect(AbstractElement.ElementBuilder::getElement).toImmutable();
            ((KlassImpl)this.element).setDeclaredAssociationEnds((ImmutableList<AssociationEnd>)declaredAssociationEnds);
            Optional<Klass> maybeSuperClass = this.superClass.map(AbstractElement.ElementBuilder::getElement);
            ((KlassImpl)this.element).setSuperClass(maybeSuperClass);
            ImmutableList subClasses = this.subClasses.collect(AbstractElement.ElementBuilder::getElement);
            ((KlassImpl)this.element).setSubClasses((ImmutableList<Klass>)subClasses);
            ImmutableList associationEnds = maybeSuperClass.map(Klass::getAssociationEnds).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty()).newWithAll((Iterable)declaredAssociationEnds).toReversed().distinctBy(NamedElement::getName).toReversed();
            ((KlassImpl)this.element).setAssociationEnds((ImmutableList<AssociationEnd>)associationEnds);
        }

        @Override
        protected ImmutableList<DataTypeProperty> getDataTypeProperties() {
            ImmutableList declaredDataTypeProperties = this.declaredDataTypeProperties.collect((Function & Serializable)property -> (DataTypeProperty)property.getElement());
            ImmutableList interfaceProperties = this.declaredInterfaces.collect(AbstractElement.ElementBuilder::getElement).flatCollect(Classifier::getDataTypeProperties).toImmutable();
            ImmutableList superClassProperties = this.superClass.map(AbstractElement.ElementBuilder::getElement).map(Classifier::getDataTypeProperties).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
            ImmutableList allDataTypeProperties = interfaceProperties.newWithAll((Iterable)superClassProperties).newWithAll((Iterable)declaredDataTypeProperties);
            ImmutableList result = allDataTypeProperties.toReversed().distinctBy(NamedElement::getName).toReversed();
            return result;
        }

        @Override
        protected ImmutableList<ReferenceProperty> getReferenceProperties() {
            ImmutableList declaredReferenceProperties = this.declaredReferenceProperties.collect((Function & Serializable)property -> (ReferenceProperty)property.getElement());
            ImmutableList superClassProperties = this.superClass.map(KlassBuilder::getReferenceProperties).orElseGet(() -> ((ImmutableListFactory)Lists.immutable).empty());
            ImmutableList interfaceProperties = this.declaredInterfaces.collect(AbstractElement.ElementBuilder::getElement).flatCollect(Classifier::getReferenceProperties).toImmutable();
            ImmutableList allReferenceProperties = interfaceProperties.newWithAll((Iterable)superClassProperties).newWithAll((Iterable)declaredReferenceProperties);
            ImmutableList result = allReferenceProperties.toReversed().distinctBy(NamedElement::getName).toReversed();
            return result;
        }

        @Override
        public KlassImpl getType() {
            return Objects.requireNonNull((KlassImpl)this.element);
        }
    }
}

