/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.meta.domain;

import com.google.common.base.Splitter;
import cool.klass.model.meta.domain.AbstractElement;
import cool.klass.model.meta.domain.api.Element;
import cool.klass.model.meta.domain.api.source.SourceCode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public final class SourceCodeImpl
implements SourceCode {
    @Nonnull
    private final String sourceName;
    @Nonnull
    private final String sourceCodeText;
    @Nonnull
    private final BufferedTokenStream tokenStream;
    @Nonnull
    private final ParserRuleContext parserContext;
    @Nonnull
    private final Optional<SourceCodeImpl> macroSourceCode;
    private Optional<Element> macroElement;

    public SourceCodeImpl(@Nonnull String sourceName, @Nonnull String sourceCodeText, @Nonnull BufferedTokenStream tokenStream, @Nonnull ParserRuleContext parserContext, @Nonnull Optional<SourceCodeImpl> macroSourceCode) {
        this.sourceName = Objects.requireNonNull(sourceName);
        this.sourceCodeText = Objects.requireNonNull(sourceCodeText);
        this.tokenStream = Objects.requireNonNull(tokenStream);
        this.parserContext = Objects.requireNonNull(parserContext);
        this.macroSourceCode = Objects.requireNonNull(macroSourceCode);
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    @Nonnull
    public String getFullPathSourceName() {
        if (this.macroElement.isEmpty()) {
            List split = Splitter.on((char)'/').splitToList((CharSequence)this.sourceName);
            return (String)split.get(split.size() - 1);
        }
        String fullPathSourceName = this.macroSourceCode.map(SourceCode::getFullPathSourceName).orElseThrow();
        AbstractElement abstractElement = (AbstractElement)this.macroElement.orElseThrow();
        Token startToken = abstractElement.getElementContext().getStart();
        return "%s:%d:%d --> %s".formatted(fullPathSourceName, startToken.getLine(), startToken.getCharPositionInLine(), this.sourceName);
    }

    @Nonnull
    public String getSourceCodeText() {
        return this.sourceCodeText;
    }

    @Nonnull
    public BufferedTokenStream getTokenStream() {
        return this.tokenStream;
    }

    @Nonnull
    public ParserRuleContext getParserContext() {
        return this.parserContext;
    }

    @Nonnull
    public Optional<SourceCode> getMacroSourceCode() {
        return this.macroSourceCode.map(Function.identity());
    }

    public String toString() {
        return this.sourceName;
    }

    public void setMacroElement(Optional<Element> macroElement) {
        if (this.macroElement != null) {
            throw new IllegalStateException();
        }
        this.macroElement = macroElement;
    }

    public static final class SourceCodeBuilderImpl
    implements SourceCode.SourceCodeBuilder {
        @Nonnull
        private final String sourceName;
        @Nonnull
        private final String sourceCodeText;
        @Nonnull
        private final BufferedTokenStream tokenStream;
        @Nonnull
        private final ParserRuleContext parserContext;
        @Nonnull
        private final Optional<SourceCodeBuilderImpl> macroSourceCodeBuilder;
        private SourceCodeImpl sourceCode;
        private Optional<AbstractElement.ElementBuilder<?>> macroElement;

        public SourceCodeBuilderImpl(@Nonnull String sourceName, @Nonnull String sourceCodeText, @Nonnull BufferedTokenStream tokenStream, @Nonnull ParserRuleContext parserContext, @Nonnull Optional<SourceCodeBuilderImpl> macroSourceCodeBuilder) {
            this.sourceName = Objects.requireNonNull(sourceName);
            this.sourceCodeText = Objects.requireNonNull(sourceCodeText);
            this.tokenStream = Objects.requireNonNull(tokenStream);
            this.parserContext = Objects.requireNonNull(parserContext);
            this.macroSourceCodeBuilder = Objects.requireNonNull(macroSourceCodeBuilder);
        }

        public SourceCodeImpl build() {
            if (this.sourceCode == null) {
                this.sourceCode = new SourceCodeImpl(this.sourceName, this.sourceCodeText, this.tokenStream, this.parserContext, this.macroSourceCodeBuilder.map(SourceCodeBuilderImpl::build));
            }
            return this.sourceCode;
        }

        public Optional<AbstractElement.ElementBuilder<?>> getMacroElement() {
            return Objects.requireNonNull(this.macroElement);
        }

        public void setMacroElement(Optional<AbstractElement.ElementBuilder<?>> macroElement) {
            if (this.macroElement != null) {
                throw new IllegalStateException();
            }
            this.macroElement = macroElement;
        }

        public void build2() {
            Optional<Element> element = this.macroElement.map(AbstractElement.ElementBuilder::getElement);
            this.sourceCode.setMacroElement(element);
        }
    }
}

