/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree.converter.graphql;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.reladomo.tree.DataTypePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferencePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNode;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.SubClassReladomoTreeNode;
import cool.klass.model.reladomo.tree.SuperClassReladomoTreeNode;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.stack.MutableStack;

public final class ReladomoTreeGraphqlConverter {
    public static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final DomainModel domainModel;

    public ReladomoTreeGraphqlConverter(DomainModel domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    public RootReladomoTreeNode convert(Klass klass, DataFetchingFieldSelectionSet selectionSet) {
        RootReladomoTreeNode result = new RootReladomoTreeNode("root", klass);
        for (SelectedField selectedField : selectionSet.getImmediateFields()) {
            this.convertSelectedField(selectedField, (ReladomoTreeNode)result);
        }
        return result;
    }

    private void convertSelectedField(SelectedField selectedField, ReladomoTreeNode parentTreeNode) {
        ReladomoTreeNode inheritancePath;
        String name = selectedField.getName();
        List objectTypeNames = selectedField.getObjectTypeNames();
        List childrenFields = selectedField.getSelectionSet().getImmediateFields();
        Klass commonClass = this.findCommonSuperClass(objectTypeNames);
        ReladomoTreeNode eachParentTreeNode = inheritancePath = ReladomoTreeGraphqlConverter.getInheritancePath(parentTreeNode, (Classifier)commonClass);
        Klass eachClass = (Klass)eachParentTreeNode.getType();
        if (childrenFields.isEmpty()) {
            if (name.equals("__typename")) {
                return;
            }
            DataTypeProperty dataTypeProperty = eachClass.getDataTypePropertyByName(name);
            if (dataTypeProperty == null) {
                String detailMessage = "Expected " + name + " to be a DataTypeProperty on " + eachClass.getName();
                throw new AssertionError((Object)detailMessage);
            }
            while (dataTypeProperty.getOwningClassifier() != eachClass && eachClass.getSuperClass().isPresent()) {
                ReladomoTreeNode nextTreeNode;
                Klass superClass = (Klass)eachClass.getSuperClass().get();
                String superClassName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
                SuperClassReladomoTreeNode nextReladomoNode = new SuperClassReladomoTreeNode(superClassName, eachClass, superClass);
                eachParentTreeNode = nextTreeNode = eachParentTreeNode.computeChild(superClassName, (ReladomoTreeNode)nextReladomoNode);
                eachClass = superClass;
            }
            DataTypePropertyReladomoTreeNode dataTypePropertyReladomoTreeNode = new DataTypePropertyReladomoTreeNode(name, dataTypeProperty);
            eachParentTreeNode.computeChild(name, (ReladomoTreeNode)dataTypePropertyReladomoTreeNode);
            return;
        }
        AssociationEnd associationEnd = eachClass.getAssociationEndByName(name);
        if (associationEnd == null) {
            String detailMessage = "Expected " + name + " to be an AssociationEnd on " + eachClass.getName();
            throw new AssertionError((Object)detailMessage);
        }
        while (associationEnd.getOwningClassifier() != eachClass && eachClass.getSuperClass().isPresent()) {
            ReladomoTreeNode nextTreeNode;
            Klass superClass = (Klass)eachClass.getSuperClass().get();
            String superClassName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
            SuperClassReladomoTreeNode nextReladomoNode = new SuperClassReladomoTreeNode(superClassName, eachClass, superClass);
            eachParentTreeNode = nextTreeNode = eachParentTreeNode.computeChild(superClassName, (ReladomoTreeNode)nextReladomoNode);
            eachClass = superClass;
        }
        ReferencePropertyReladomoTreeNode associationEndReladomoTreeNode = new ReferencePropertyReladomoTreeNode(name, (ReferenceProperty)associationEnd);
        ReladomoTreeNode reladomoTreeNode = eachParentTreeNode.computeChild(name, (ReladomoTreeNode)associationEndReladomoTreeNode);
        for (SelectedField childSelectedField : childrenFields) {
            this.convertSelectedField(childSelectedField, reladomoTreeNode);
        }
    }

    private Klass findCommonSuperClass(List<String> objectTypeNames) {
        ImmutableList classes = Lists.immutable.withAll(objectTypeNames).collect(arg_0 -> ((DomainModel)this.domainModel).getClassByName(arg_0));
        if (classes.size() == 1) {
            return (Klass)classes.getOnly();
        }
        MutableBag classCounts = classes.flatCollect(Klass::getSuperClassChainWithThis).toBag();
        Klass result = (Klass)((Klass)classes.getFirst()).getSuperClassChainWithThis().detect((Predicate & Serializable)each -> classCounts.occurrencesOf(each) == classes.size());
        return Objects.requireNonNull(result);
    }

    public static ReladomoTreeNode getInheritancePath(ReladomoTreeNode reladomoNode, Classifier end) {
        ReladomoTreeNode eachReladomoNode = reladomoNode;
        Classifier start = (Classifier)reladomoNode.getType();
        if (start.isStrictSubTypeOf(end)) {
            Klass eachKlass = (Klass)start;
            while (eachKlass != end) {
                Klass superClass = eachKlass.getSuperClass().orElse(null);
                if (superClass == null) {
                    return eachReladomoNode;
                }
                String name = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
                SuperClassReladomoTreeNode nextReladomoNode = new SuperClassReladomoTreeNode(name, eachKlass, superClass);
                eachReladomoNode = eachReladomoNode.computeChild(name, (ReladomoTreeNode)nextReladomoNode);
                eachKlass = superClass;
            }
            return eachReladomoNode;
        }
        if (start.isStrictSuperTypeOf(end)) {
            MutableStack stack = Stacks.mutable.empty();
            Klass eachClassifier = (Klass)end;
            while (eachClassifier != start) {
                Klass superClass = (Klass)eachClassifier.getSuperClass().get();
                stack.push((Object)eachClassifier);
                eachClassifier = superClass;
            }
            Klass eachClassifier2 = (Klass)start;
            while (stack.notEmpty()) {
                Klass eachSubClass = (Klass)stack.pop();
                String name = (String)UPPER_TO_LOWER_CAMEL.convert((Object)eachSubClass.getName()) + "SubClass";
                SubClassReladomoTreeNode nextReladomoNode = new SubClassReladomoTreeNode(name, eachClassifier2, eachSubClass);
                eachReladomoNode = eachReladomoNode.computeChild(name, (ReladomoTreeNode)nextReladomoNode);
                eachClassifier2 = eachSubClass;
            }
            return eachReladomoNode;
        }
        return start == end ? eachReladomoNode : null;
    }
}

