/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.projection;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.projection.Projection;
import cool.klass.model.meta.domain.api.projection.ProjectionChild;
import cool.klass.model.meta.domain.api.projection.ProjectionDataTypeProperty;
import cool.klass.model.meta.domain.api.projection.ProjectionParent;
import cool.klass.model.meta.domain.api.projection.ProjectionProjectionReference;
import cool.klass.model.meta.domain.api.projection.ProjectionReferenceProperty;
import cool.klass.model.meta.domain.api.property.Property;
import cool.klass.model.reladomo.projection.ProjectionDataTypePropertyReladomoNode;
import cool.klass.model.reladomo.projection.ProjectionElementReladomoNode;
import cool.klass.model.reladomo.projection.ProjectionProjectionReferenceReladomoNode;
import cool.klass.model.reladomo.projection.ProjectionReferencePropertyReladomoNode;
import cool.klass.model.reladomo.projection.RootReladomoNode;
import cool.klass.model.reladomo.projection.SubClassReladomoNode;
import cool.klass.model.reladomo.projection.SuperClassReladomoNode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public final class ReladomoProjectionConverter {
    public static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final MutableOrderedMap<Projection, RootReladomoNode> rootNodesByProjection = OrderedMapAdapter.adapt(new LinkedHashMap());
    private final MutableMap<ProjectionProjectionReference, ProjectionElementReladomoNode> projectionHoldersByProjectionReference = Maps.mutable.empty();

    @Nonnull
    public RootReladomoNode getRootReladomoNode(Classifier classifier, Projection projection) {
        RootReladomoNode projectionReladomoNode = new RootReladomoNode("root", classifier, projection);
        this.projectionChildrenToReladomoTree(projectionReladomoNode, (ProjectionParent)projection);
        this.rootNodesByProjection.put((Object)projection, (Object)projectionReladomoNode);
        this.projectionHoldersByProjectionReference.toImmutable().forEachKeyValue((Procedure2 & Serializable)(eachProjectionReference, eachProjectionReferenceNode) -> {
            RootReladomoNode rootReladomoNode = (RootReladomoNode)this.rootNodesByProjection.getIfAbsent((Object)eachProjectionReference.getProjection(), (Function0 & Serializable)() -> this.getRootReladomoNode(eachProjectionReference.getClassifier(), eachProjectionReference.getProjection()));
            eachProjectionReferenceNode.setProjection(rootReladomoNode);
            this.projectionHoldersByProjectionReference.remove(eachProjectionReference);
        });
        return projectionReladomoNode;
    }

    public void projectionChildrenToReladomoTree(ProjectionElementReladomoNode reladomoNode, ProjectionParent projectionParent) {
        for (ProjectionChild projectionChild : projectionParent.getChildren()) {
            this.projectionElementToReladomoTree(reladomoNode, projectionChild);
        }
    }

    private void projectionElementToReladomoTree(ProjectionElementReladomoNode projectionReladomoNode, ProjectionChild projectionChild) {
        Property property = projectionChild.getProperty();
        String name = property.getName();
        ProjectionElementReladomoNode reladomoNode = projectionReladomoNode;
        if ((reladomoNode = ReladomoProjectionConverter.getInheritancePath(reladomoNode, property.getOwningClassifier())) == null) {
            return;
        }
        if (projectionChild instanceof ProjectionProjectionReference) {
            ProjectionProjectionReference projectionProjectionReference = (ProjectionProjectionReference)projectionChild;
            ProjectionProjectionReferenceReladomoNode childNode = new ProjectionProjectionReferenceReladomoNode(name, projectionProjectionReference);
            reladomoNode = reladomoNode.computeChild(name, childNode);
            reladomoNode = ReladomoProjectionConverter.getInheritancePath(reladomoNode, projectionProjectionReference.getProjection().getClassifier());
            this.projectionHoldersByProjectionReference.put((Object)projectionProjectionReference, (Object)reladomoNode);
        } else if (projectionChild instanceof ProjectionReferenceProperty) {
            ProjectionReferenceProperty projectionReferenceProperty = (ProjectionReferenceProperty)projectionChild;
            ProjectionReferencePropertyReladomoNode childNode = new ProjectionReferencePropertyReladomoNode(name, projectionReferenceProperty);
            reladomoNode = reladomoNode.computeChild(name, childNode);
            this.projectionChildrenToReladomoTree(reladomoNode, (ProjectionParent)projectionReferenceProperty);
        } else if (projectionChild instanceof ProjectionDataTypeProperty) {
            ProjectionDataTypeProperty projectionDataTypeProperty = (ProjectionDataTypeProperty)projectionChild;
            ProjectionDataTypePropertyReladomoNode childNode = new ProjectionDataTypePropertyReladomoNode(name, projectionDataTypeProperty);
            reladomoNode = reladomoNode.computeChild(name, childNode);
        } else {
            throw new AssertionError((Object)("Expected ProjectionProjectionReference or ProjectionReferenceProperty but got " + projectionChild.getClass().getCanonicalName()));
        }
    }

    public static ProjectionElementReladomoNode getInheritancePath(ProjectionElementReladomoNode reladomoNode, Classifier end) {
        ProjectionElementReladomoNode eachReladomoNode = reladomoNode;
        Classifier start = (Classifier)reladomoNode.getType();
        if (start.isStrictSubTypeOf(end)) {
            Klass eachKlass = (Klass)start;
            while (eachKlass != end) {
                Klass superClass = eachKlass.getSuperClass().orElse(null);
                if (superClass == null) {
                    return eachReladomoNode;
                }
                String name = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
                SuperClassReladomoNode nextReladomoNode = new SuperClassReladomoNode(name, eachKlass, superClass);
                eachReladomoNode = eachReladomoNode.computeChild(name, nextReladomoNode);
                eachKlass = superClass;
            }
            return eachReladomoNode;
        }
        if (start.isStrictSuperTypeOf(end)) {
            MutableStack stack = Stacks.mutable.empty();
            Klass eachClassifier = (Klass)end;
            while (eachClassifier != start) {
                Klass superClass = (Klass)eachClassifier.getSuperClass().get();
                stack.push((Object)eachClassifier);
                eachClassifier = superClass;
            }
            Klass eachClassifier2 = (Klass)start;
            while (stack.notEmpty()) {
                Klass eachSubClass = (Klass)stack.pop();
                String name = (String)UPPER_TO_LOWER_CAMEL.convert((Object)eachSubClass.getName()) + "SubClass";
                SubClassReladomoNode nextReladomoNode = new SubClassReladomoNode(name, eachClassifier2, eachSubClass);
                eachReladomoNode = eachReladomoNode.computeChild(name, nextReladomoNode);
                eachClassifier2 = eachSubClass;
            }
            return eachReladomoNode;
        }
        if (start == end) {
            return eachReladomoNode;
        }
        return null;
    }
}

