/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Type;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareWalkerVisitor;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeVisitor;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeWalkerVisitor;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.stack.MutableStack;

public interface ReladomoTreeNode {
    public void visit(ReladomoTreeNodeVisitor var1);

    default public void walk(ReladomoTreeNodeListener listener) {
        this.visit(new ReladomoTreeNodeWalkerVisitor(listener));
    }

    default public void toManyAwareWalk(ReladomoTreeNodeToManyAwareListener listener) {
        this.visit(new ReladomoTreeNodeToManyAwareWalkerVisitor(listener));
    }

    public String getName();

    public Classifier getOwningClassifier();

    public Type getType();

    public MapIterable<String, ReladomoTreeNode> getChildren();

    public ReladomoTreeNode computeChild(String var1, ReladomoTreeNode var2);

    default public String getShortString() {
        return "." + this.getName();
    }

    default public String getNodeString(String indent) {
        return indent + this.getOwningClassifier().getName() + this.getShortString() + ": " + this.getType().getName() + "\n";
    }

    default public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    default public ImmutableList<String> getDeepFetchStrings() {
        if (this.isLeaf()) {
            return Lists.immutable.empty();
        }
        MutableList result = Lists.mutable.empty();
        MutableStack stack = Stacks.mutable.empty();
        this.getDeepFetchStrings((MutableList<String>)result, (MutableStack<String>)stack);
        return result.toImmutable();
    }

    private void getDeepFetchStrings(MutableList<String> result, MutableStack<String> stack) {
        stack.push((Object)this.getShortString());
        if (this.isLeaf()) {
            String string = stack.toList().asReversed().makeString("");
            result.add((Object)string);
        } else {
            for (ReladomoTreeNode child : this.getChildren()) {
                child.getDeepFetchStrings(result, stack);
            }
        }
        stack.pop();
    }

    public String toString(String var1);
}

