/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.AbstractReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeVisitor;
import java.util.Objects;

public class SuperClassReladomoTreeNode
extends AbstractReladomoTreeNode {
    private final Klass klass;
    private final Klass superClass;

    public SuperClassReladomoTreeNode(String name, Klass klass, Klass superClass) {
        super(name);
        this.klass = Objects.requireNonNull(klass);
        this.superClass = Objects.requireNonNull(superClass);
    }

    @Override
    public void visit(ReladomoTreeNodeVisitor visitor) {
        visitor.visitSuperClass(this);
    }

    public Klass getOwningClassifier() {
        return this.klass;
    }

    public Klass getType() {
        return this.superClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperClassReladomoTreeNode that = (SuperClassReladomoTreeNode)o;
        return this.klass.equals((Object)that.klass) && this.superClass.equals((Object)that.superClass);
    }

    public int hashCode() {
        int result = this.klass.hashCode();
        result = 31 * result + this.superClass.hashCode();
        return result;
    }
}

