/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.ReladomoTreeNode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.map.mutable.MapAdapter;

public abstract class AbstractReladomoTreeNode
implements ReladomoTreeNode {
    protected final MutableMap<String, ReladomoTreeNode> children = MapAdapter.adapt(new LinkedHashMap());
    private final String name;

    protected AbstractReladomoTreeNode(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapIterable<String, ReladomoTreeNode> getChildren() {
        return this.children.asUnmodifiable();
    }

    @Override
    public ReladomoTreeNode computeChild(String childName, ReladomoTreeNode childNode) {
        if (this.getType() != childNode.getOwningClassifier() && childNode.getOwningClassifier() instanceof Klass) {
            String detailMessage = "Type mismatch: %s != %s for %s".formatted(this.getType(), childNode.getOwningClassifier(), childName);
            throw new AssertionError((Object)detailMessage);
        }
        ReladomoTreeNode result = (ReladomoTreeNode)this.children.getIfAbsentPut((Object)childName, (Object)childNode);
        if (!Objects.equals(result, childNode)) {
            String detailMessage = "Expected %s but got %s for %s".formatted(result, childNode, childName);
            throw new AssertionError((Object)detailMessage);
        }
        return result;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        RichIterable childrenStrings = this.getChildren().keyValuesView().collect((Function & Serializable)pair -> ((ReladomoTreeNode)pair.getTwo()).toString(indent + "  "));
        String result = this.getNodeString(indent) + childrenStrings.makeString("");
        return result;
    }
}

