/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.reladomo.tree.DataTypePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferencePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferenceReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeVisitor;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.SubClassReladomoTreeNode;
import cool.klass.model.reladomo.tree.SuperClassReladomoTreeNode;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.block.procedure.Procedure2;

public class ReladomoTreeNodeToManyAwareWalkerVisitor
implements ReladomoTreeNodeVisitor {
    private final ReladomoTreeNodeToManyAwareListener listener;

    public ReladomoTreeNodeToManyAwareWalkerVisitor(ReladomoTreeNodeToManyAwareListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    @Override
    public void visitRoot(RootReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        Optional<Integer> maybeNumChildren = this.listener.enterRoot(node);
        this.visitChildren(node, maybeNumChildren);
        this.listener.exitRoot(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    @Override
    public void visitDataTypeProperty(DataTypePropertyReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        this.listener.enterDataTypeProperty(node);
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitDataTypeProperty(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    @Override
    public void visitSuperClass(SuperClassReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        this.listener.enterSuperClass(node);
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitSuperClass(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    @Override
    public void visitSubClass(SubClassReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        this.listener.enterSubClass(node);
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitSubClass(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    @Override
    public void visitReferenceProperty(ReferencePropertyReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        Optional<Integer> maybeNumChildren = this.listener.enterReferenceProperty(node);
        this.visitChildren(node, maybeNumChildren);
        this.listener.exitReferenceProperty(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    @Override
    public void visit(ReferenceReladomoTreeNode node) {
        Object before = this.listener.getStateToAssertInvariants();
        Optional<Integer> maybeNumChildren = this.listener.enterReference(node);
        this.visitChildren(node, maybeNumChildren);
        this.listener.exitReference(node);
        Object after = this.listener.getStateToAssertInvariants();
        if (!Objects.equals(before, after)) {
            throw new IllegalStateException("State changed during visit");
        }
    }

    private void visitChildren(ReladomoTreeNode node, Optional<Integer> maybeNumChildren) {
        if (maybeNumChildren.isEmpty()) {
            node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
            return;
        }
        Integer numChildren = maybeNumChildren.get();
        for (int i = 0; i < numChildren; ++i) {
            this.listener.enterListIndex(i);
            node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
            this.listener.exitListIndex(i);
        }
    }
}

