/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.reladomo.tree.DataTypePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferencePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferenceReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeVisitor;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.SubClassReladomoTreeNode;
import cool.klass.model.reladomo.tree.SuperClassReladomoTreeNode;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.collections.api.block.procedure.Procedure2;

public class ReladomoTreeNodeWalkerVisitor
implements ReladomoTreeNodeVisitor {
    private final ReladomoTreeNodeListener listener;

    public ReladomoTreeNodeWalkerVisitor(ReladomoTreeNodeListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    @Override
    public void visitRoot(RootReladomoTreeNode node) {
        this.listener.enterRoot(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitRoot(node);
        this.listener.assertInvariants();
    }

    @Override
    public void visitDataTypeProperty(DataTypePropertyReladomoTreeNode node) {
        this.listener.enterDataTypeProperty(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitDataTypeProperty(node);
        this.listener.assertInvariants();
    }

    @Override
    public void visitSuperClass(SuperClassReladomoTreeNode node) {
        this.listener.enterSuperClass(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitSuperClass(node);
        this.listener.assertInvariants();
    }

    @Override
    public void visitSubClass(SubClassReladomoTreeNode node) {
        this.listener.enterSubClass(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitSubClass(node);
        this.listener.assertInvariants();
    }

    @Override
    public void visitReferenceProperty(ReferencePropertyReladomoTreeNode node) {
        this.listener.enterReferenceProperty(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitReferenceProperty(node);
        this.listener.assertInvariants();
    }

    @Override
    public void visit(ReferenceReladomoTreeNode node) {
        this.listener.enterReference(node);
        this.listener.assertInvariants();
        node.getChildren().forEachKeyValue((Procedure2 & Serializable)(name, child) -> child.visit(this));
        this.listener.exitReference(node);
        this.listener.assertInvariants();
    }
}

