/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.reladomo.tree;

import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.reladomo.tree.AbstractReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeVisitor;
import java.util.Objects;

public class SubClassReladomoTreeNode
extends AbstractReladomoTreeNode {
    private final Klass klass;
    private final Klass subClass;

    public SubClassReladomoTreeNode(String name, Klass klass, Klass subClass) {
        super(name);
        this.klass = Objects.requireNonNull(klass);
        this.subClass = Objects.requireNonNull(subClass);
    }

    @Override
    public void visit(ReladomoTreeNodeVisitor visitor) {
        visitor.visitSubClass(this);
    }

    public Klass getOwningClassifier() {
        return this.klass;
    }

    public Klass getType() {
        return this.subClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubClassReladomoTreeNode that = (SubClassReladomoTreeNode)o;
        return this.klass.equals(that.klass) && this.subClass.equals(that.subClass);
    }

    public int hashCode() {
        int result = this.klass.hashCode();
        result = 31 * result + this.subClass.hashCode();
        return result;
    }
}

