/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.graphql.deep.fetcher;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.finder.DomainList;
import com.gs.fw.finder.Navigation;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.Objects;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;

public final class GraphQLDeepFetcher {
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private DomainModel domainModel;

    public DomainModel getDomainModel() {
        return this.domainModel;
    }

    public void setDomainModel(DomainModel domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    public <T> void deepFetch(DomainList<T> result, String className, RelatedFinder<T> finderInstance, DataFetchingFieldSelectionSet selectionSet) {
        Klass klass = this.domainModel.getClassByName(className);
        for (SelectedField selectedField : selectionSet.getFields()) {
            this.deepFetchSelectedField(result, klass, finderInstance, selectedField);
        }
    }

    private <T> void deepFetchSelectedField(DomainList<T> result, Klass klass, RelatedFinder<T> finderInstance, SelectedField selectedField) {
        Objects.requireNonNull(finderInstance);
        Objects.requireNonNull(klass);
        String qualifiedName = selectedField.getQualifiedName();
        ArrayAdapter fieldNamesNames = ArrayAdapter.adapt((Object[])qualifiedName.split("/"));
        MutableList navigationNames = fieldNamesNames.take(fieldNamesNames.size() - 1);
        if (navigationNames.isEmpty()) {
            return;
        }
        RelatedFinder currentFinder = finderInstance;
        Klass currentClass = klass;
        for (String navigationName : navigationNames) {
            AssociationEnd associationEnd = currentClass.getDeclaredAssociationEndByName(navigationName);
            while (associationEnd == null) {
                Klass superClass = (Klass)currentClass.getSuperClass().get();
                String superClassNavigationName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
                currentClass = superClass;
                currentFinder = currentFinder.getRelationshipFinderByName(superClassNavigationName);
                Objects.requireNonNull(currentFinder);
                associationEnd = currentClass.getDeclaredAssociationEndByName(navigationName);
            }
            currentClass = associationEnd.getType();
            currentFinder = currentFinder.getRelationshipFinderByName(navigationName);
            Objects.requireNonNull(currentFinder);
        }
        if (!(currentFinder instanceof Navigation)) {
            throw new IllegalStateException("Expected a navigation, but got: " + currentFinder);
        }
        Navigation navigation = (Navigation)currentFinder;
        result.deepFetch(navigation);
    }
}

