/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.persistent.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.data.store.DataStore;
import cool.klass.deserializer.json.JsonDataTypeValueVisitor;
import cool.klass.deserializer.json.OperationMode;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.reladomo.persistent.writer.MutationContext;
import cool.klass.reladomo.persistent.writer.PersistentDeleter;
import java.io.Serializable;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.partition.list.PartitionImmutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.utility.ListIterate;

public abstract class PersistentSynchronizer {
    @Nonnull
    protected final MutationContext mutationContext;
    @Nonnull
    protected final DataStore dataStore;
    protected boolean inTransaction;

    protected PersistentSynchronizer(@Nonnull MutationContext mutationContext, @Nonnull DataStore dataStore, boolean inTransaction) {
        this.mutationContext = Objects.requireNonNull(mutationContext);
        this.dataStore = Objects.requireNonNull(dataStore);
        this.inTransaction = inTransaction;
    }

    protected abstract boolean shouldWriteKey();

    protected abstract boolean shouldWriteId();

    public boolean synchronize(@Nonnull Klass klass, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        Runnable noop = () -> {};
        return this.synchronize(klass, persistentInstance, incomingJson, noop);
    }

    public boolean synchronize(@Nonnull Klass klass, Object persistentInstance, @Nonnull ObjectNode incomingJson, Runnable finalizer) {
        if (this.inTransaction) {
            throw new AssertionError();
        }
        return (Boolean)this.dataStore.runInTransaction(transaction -> {
            Instant transactionTime = this.mutationContext.getTransactionTime();
            long transactionTimeMillis = transactionTime.toEpochMilli();
            transaction.setSystemTime(transactionTimeMillis);
            this.inTransaction = true;
            try {
                boolean result = this.synchronizeInTransaction(klass, Optional.empty(), persistentInstance, incomingJson);
                finalizer.run();
                Boolean bl = result;
                return bl;
            }
            finally {
                this.inTransaction = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWithoutStartingTransaction(@Nonnull Klass klass, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        if (this.inTransaction) {
            throw new AssertionError();
        }
        this.inTransaction = true;
        try {
            this.synchronizeInTransaction(klass, Optional.empty(), persistentInstance, incomingJson);
        }
        finally {
            this.inTransaction = false;
        }
    }

    protected boolean synchronizeInTransaction(@Nonnull Klass klass, @Nonnull Optional<AssociationEnd> pathHere, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        if (!this.inTransaction) {
            throw new AssertionError();
        }
        boolean propertyMutationOccurred = false;
        if (!this.isRestrictedFromWriting(klass)) {
            propertyMutationOccurred |= this.synchronizeDataTypeProperties(klass, persistentInstance, incomingJson);
        }
        boolean associatedMutationOccurred = this.synchronizeAssociationEnds(klass, pathHere, persistentInstance, incomingJson);
        boolean mutationOccurred = propertyMutationOccurred || associatedMutationOccurred;
        this.synchronizeUpdatedDataTypeProperties(klass, persistentInstance, propertyMutationOccurred);
        if (mutationOccurred) {
            klass.getVersionProperty().ifPresent(associationEnd -> this.handleVersion((AssociationEnd)associationEnd, persistentInstance));
        }
        return mutationOccurred;
    }

    protected abstract void synchronizeUpdatedDataTypeProperties(@Nonnull Klass var1, Object var2, boolean var3);

    protected void synchronizeUpdatedDataTypeProperties(Klass klass, Object persistentInstance) {
        Optional lastUpdatedByProperty = klass.getLastUpdatedByProperty();
        lastUpdatedByProperty.ifPresent(primitiveProperty -> {
            Optional<String> optionalUserId = this.mutationContext.getUserId();
            String userId = optionalUserId.orElseThrow(() -> new AssertionError(primitiveProperty));
            this.dataStore.setDataTypeProperty(persistentInstance, (DataTypeProperty)primitiveProperty, (Object)userId);
        });
    }

    private boolean isRestrictedFromWriting(@Nonnull Klass klass) {
        return klass.isTransient() || klass.getVersionedProperty().isPresent();
    }

    protected boolean synchronizeDataTypeProperties(@Nonnull Klass klass, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        ImmutableList dataTypeProperties = klass.getDataTypeProperties();
        ImmutableList simpleDataTypeProperties = dataTypeProperties.rejectWith(this::shouldSkipDataTypeProperty, (Object)klass);
        this.validateSetIdDataTypeProperties(klass, persistentInstance);
        boolean mutationOccurred = false;
        for (DataTypeProperty dataTypeProperty : simpleDataTypeProperties) {
            mutationOccurred |= this.synchronizeDataTypeProperty(dataTypeProperty, persistentInstance, incomingJson);
        }
        this.synchronizeCreatedDataTypeProperties(klass, persistentInstance);
        return mutationOccurred;
    }

    protected abstract void validateSetIdDataTypeProperties(Klass var1, Object var2);

    protected abstract void synchronizeCreatedDataTypeProperties(Klass var1, Object var2);

    protected boolean synchronizeDataTypeProperty(@Nonnull DataTypeProperty dataTypeProperty, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        Object newValue = this.mutationContext.getPropertyDataFromUrl().getIfAbsent((Object)dataTypeProperty, (Function0 & Serializable)() -> JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)dataTypeProperty, (ObjectNode)incomingJson));
        return this.dataStore.setDataTypeProperty(persistentInstance, dataTypeProperty, newValue);
    }

    private boolean shouldSkipDataTypeProperty(@Nonnull DataTypeProperty dataTypeProperty, @Nonnull Klass klass) {
        return dataTypeProperty.isForeignKey() || dataTypeProperty.isAudit() || dataTypeProperty.isTemporal() || dataTypeProperty.isDerived() || this.hasReferencePropertyDependentOnDataTypeProperty(klass, dataTypeProperty) || dataTypeProperty.isKey() && !this.shouldWriteKey() || dataTypeProperty.isID() && !this.shouldWriteId();
    }

    private boolean synchronizeAssociationEnds(@Nonnull Klass klass, @Nonnull Optional<AssociationEnd> pathHere, Object persistentInstance, @Nonnull ObjectNode incomingObjectNode) {
        JsonNode jsonNode;
        Multiplicity multiplicity;
        PartitionImmutableList forwardOwnedAssociationEnds = klass.getAssociationEnds().reject((Predicate & Serializable)associationEnd -> pathHere.equals(Optional.of(associationEnd.getOpposite()))).reject(ReferenceProperty::isVersion).reject(ReferenceProperty::isAudit).partition(ReferenceProperty::isOwned);
        boolean mutationOccurred = false;
        for (AssociationEnd associationEnd2 : forwardOwnedAssociationEnds.getSelected()) {
            multiplicity = associationEnd2.getMultiplicity();
            jsonNode = incomingObjectNode.path(associationEnd2.getName());
            if (multiplicity.isToOne()) {
                mutationOccurred |= this.handleToOne(associationEnd2, persistentInstance, jsonNode);
                continue;
            }
            mutationOccurred |= this.handleToMany(associationEnd2, persistentInstance, jsonNode);
        }
        for (AssociationEnd associationEnd2 : forwardOwnedAssociationEnds.getRejected()) {
            multiplicity = associationEnd2.getMultiplicity();
            jsonNode = incomingObjectNode.path(associationEnd2.getName());
            if (multiplicity.isToOne()) {
                mutationOccurred |= this.handleToOneOutsideProjection(associationEnd2, persistentInstance, incomingObjectNode, jsonNode);
                continue;
            }
            mutationOccurred |= this.handleToManyOutsideProjection(associationEnd2, persistentInstance, incomingObjectNode, jsonNode);
        }
        return mutationOccurred;
    }

    protected abstract void handleVersion(AssociationEnd var1, Object var2);

    private boolean handleToOne(@Nonnull AssociationEnd associationEnd, Object persistentParentInstance, @Nonnull JsonNode incomingChildInstance) {
        Object persistentChildInstance = this.dataStore.getToOne(persistentParentInstance, (ReferenceProperty)associationEnd);
        if (persistentChildInstance == null && !incomingChildInstance.isMissingNode() && !incomingChildInstance.isNull()) {
            MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
            this.insert(associationEnd, persistentParentInstance, incomingChildInstance, keys);
            return true;
        }
        if (persistentChildInstance != null && incomingChildInstance.isMissingNode() || incomingChildInstance.isNull()) {
            if (incomingChildInstance.isMissingNode()) {
                return this.handleMissingToOne(associationEnd.getType(), persistentChildInstance);
            }
            if (incomingChildInstance.isNull()) {
                return this.handleNullToOne(associationEnd.getType(), persistentChildInstance);
            }
        }
        if (persistentChildInstance != null && incomingChildInstance != null) {
            PersistentSynchronizer synchronizer = this.determineNextMode(OperationMode.REPLACE);
            return synchronizer.synchronizeInTransaction(associationEnd.getType(), Optional.of(associationEnd), persistentChildInstance, (ObjectNode)incomingChildInstance);
        }
        return false;
    }

    protected boolean handleMissingToOne(Klass klass, Object persistentChildInstance) {
        this.deleteOrTerminate(klass, persistentChildInstance);
        return true;
    }

    protected boolean handleNullToOne(Klass klass, Object persistentChildInstance) {
        this.deleteOrTerminate(klass, persistentChildInstance);
        return true;
    }

    protected abstract boolean handleToOneOutsideProjection(@Nonnull AssociationEnd var1, @Nonnull Object var2, @Nonnull ObjectNode var3, @Nonnull JsonNode var4);

    protected Object findExistingChildPersistentInstance(@Nonnull Object persistentParentInstance, @Nonnull JsonNode incomingChildInstance, @Nonnull AssociationEnd associationEnd) {
        MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
        return this.dataStore.findByKey(associationEnd.getType(), keys);
    }

    private void insert(@Nonnull AssociationEnd associationEnd, Object persistentParentInstance, JsonNode incomingChildInstance, MapIterable<DataTypeProperty, Object> keys) {
        Klass resultType = associationEnd.getType();
        Object newInstance = this.dataStore.instantiate(resultType, keys);
        PersistentSynchronizer synchronizer = this.determineNextMode(OperationMode.CREATE);
        boolean mutationOccurred = synchronizer.synchronizeInTransaction(resultType, Optional.of(associationEnd), newInstance, (ObjectNode)incomingChildInstance);
        if (!mutationOccurred) {
            // empty if block
        }
        this.dataStore.setToOne(persistentParentInstance, associationEnd, newInstance);
        this.dataStore.insert(newInstance);
    }

    private void deleteOrTerminate(Klass klass, @Nonnull Object persistentInstance) {
        PersistentDeleter reladomoPersistentDeleter = new PersistentDeleter(this.mutationContext, this.dataStore);
        reladomoPersistentDeleter.deleteOrTerminate(klass, persistentInstance);
    }

    protected boolean handleToMany(@Nonnull AssociationEnd associationEnd, Object persistentParentInstance, @Nonnull JsonNode incomingChildInstances) {
        boolean mutationOccurred = false;
        ImmutableList incomingInstancesForUpdate = Lists.immutable.withAll((Iterable)incomingChildInstances).rejectWith(this::jsonNodeNeedsIdInferredOnInsert, (Object)associationEnd);
        MapIterable<MapIterable<DataTypeProperty, Object>, JsonNode> incomingChildInstancesByKey = this.indexIncomingJsonInstances((Iterable<JsonNode>)incomingInstancesForUpdate, associationEnd, persistentParentInstance);
        List persistentChildInstances = this.dataStore.getToMany(persistentParentInstance, (ReferenceProperty)associationEnd);
        for (Object persistentChildInstance : persistentChildInstances) {
            ImmutableMap<DataTypeProperty, Object> keys = this.getKeysFromPersistentInstance(persistentChildInstance, associationEnd.getType());
            if (incomingChildInstancesByKey.containsKey(keys)) continue;
            PersistentDeleter reladomoPersistentDeleter = new PersistentDeleter(this.mutationContext, this.dataStore);
            reladomoPersistentDeleter.deleteOrTerminate(associationEnd.getType(), persistentChildInstance);
            mutationOccurred = true;
        }
        List nonTerminatedPersistentChildInstances = this.dataStore.getToMany(persistentParentInstance, (ReferenceProperty)associationEnd);
        MapIterable<MapIterable<DataTypeProperty, Object>, Object> persistentChildInstancesByKey = this.indexPersistentInstances(nonTerminatedPersistentChildInstances, associationEnd.getType());
        for (JsonNode incomingChildInstance : incomingChildInstances) {
            Object persistentChildInstance = this.getPersistentChildInstance(associationEnd, persistentParentInstance, persistentChildInstancesByKey, incomingChildInstance);
            if (persistentChildInstance == null) {
                if (!associationEnd.isOwned()) {
                    throw new AssertionError();
                }
                Klass resultType = associationEnd.getType();
                MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
                Object newInstance = this.dataStore.instantiate(resultType, keys);
                this.dataStore.setToOne(newInstance, associationEnd.getOpposite(), persistentParentInstance);
                PersistentSynchronizer synchronizer = this.determineNextMode(OperationMode.CREATE);
                synchronizer.synchronizeInTransaction(associationEnd.getType(), Optional.of(associationEnd), newInstance, (ObjectNode)incomingChildInstance);
                this.dataStore.insert(newInstance);
                mutationOccurred = true;
                continue;
            }
            PersistentSynchronizer synchronizer = this.determineNextMode(OperationMode.REPLACE);
            mutationOccurred |= synchronizer.synchronizeInTransaction(associationEnd.getType(), Optional.of(associationEnd), persistentChildInstance, (ObjectNode)incomingChildInstance);
        }
        return mutationOccurred;
    }

    @Nullable
    private Object getPersistentChildInstance(@Nonnull AssociationEnd associationEnd, Object persistentParentInstance, @Nonnull MapIterable<MapIterable<DataTypeProperty, Object>, Object> persistentChildInstancesByKey, @Nonnull JsonNode incomingChildInstance) {
        if (this.jsonNodeNeedsIdInferredOnInsert(incomingChildInstance, associationEnd)) {
            return null;
        }
        MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
        return persistentChildInstancesByKey.get(keys);
    }

    private boolean handleToManyOutsideProjection(@Nonnull AssociationEnd associationEnd, @Nonnull Object persistentParentInstance, @Nonnull ObjectNode incomingParentNode, @Nonnull JsonNode incomingChildInstances) {
        if (incomingChildInstances.isMissingNode()) {
            return false;
        }
        boolean mutationOccurred = false;
        MapIterable<MapIterable<DataTypeProperty, Object>, JsonNode> incomingChildInstancesByKey = this.indexIncomingJsonInstances((Iterable<JsonNode>)incomingChildInstances, associationEnd, persistentParentInstance);
        List persistentChildInstances = this.dataStore.getToMany(persistentParentInstance, (ReferenceProperty)associationEnd);
        for (Object persistentChildInstance : persistentChildInstances) {
            ImmutableMap<DataTypeProperty, Object> keys = this.getKeysFromPersistentInstance(persistentChildInstance, associationEnd.getType());
            if (!incomingChildInstancesByKey.containsKey(keys)) {
                throw new AssertionError();
            }
        }
        MapIterable<MapIterable<DataTypeProperty, Object>, Object> persistentChildInstancesByKey = this.indexPersistentInstances(persistentChildInstances, associationEnd.getType());
        for (JsonNode incomingChildInstance : incomingChildInstances) {
            MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
            Object persistentChildInstance = persistentChildInstancesByKey.get(keys);
            if (persistentChildInstance == null) {
                if (associationEnd.isOwned()) {
                    throw new AssertionError();
                }
                throw new AssertionError();
            }
            PersistentSynchronizer synchronizer = this.determineNextMode(OperationMode.REPLACE);
            mutationOccurred = synchronizer.synchronizeInTransaction(associationEnd.getType(), Optional.of(associationEnd), persistentChildInstance, (ObjectNode)incomingChildInstance);
        }
        return mutationOccurred;
    }

    @Nonnull
    private MapIterable<MapIterable<DataTypeProperty, Object>, JsonNode> indexIncomingJsonInstances(@Nonnull Iterable<JsonNode> incomingInstances, @Nonnull AssociationEnd associationEnd, Object persistentParentInstance) {
        MutableOrderedMap result = OrderedMapAdapter.adapt(new LinkedHashMap());
        for (JsonNode incomingInstance : incomingInstances) {
            MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingInstance, associationEnd, persistentParentInstance);
            result.put(keys, (Object)incomingInstance);
        }
        return result.asUnmodifiable();
    }

    protected ImmutableMap<DataTypeProperty, Object> getKeysFromPersistentInstance(Object persistentInstance, @Nonnull Klass klass) {
        return klass.getKeyProperties().toImmutableMap((Function & Serializable)keyProperty -> keyProperty, (Function & Serializable)keyProperty -> this.dataStore.getDataTypeProperty(persistentInstance, keyProperty));
    }

    @Nonnull
    protected abstract PersistentSynchronizer determineNextMode(OperationMode var1);

    private boolean hasReferencePropertyDependentOnDataTypeProperty(Klass klass, DataTypeProperty dataTypeProperty) {
        return false;
    }

    private ImmutableList<DataTypeProperty> getNonDerivedDataTypeProperties(ImmutableList<DataTypeProperty> dataTypeProperties) {
        return dataTypeProperties;
    }

    private void handleForeignKeysForAssociationsOutsideProjection(Object persistentInstance, ObjectNode incomingJson, Klass klass) {
    }

    private Object getKeyFromJsonNode(@Nonnull DataTypeProperty keyProperty, @Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, Object persistentParentInstance) {
        AssociationEnd opposite;
        OrderedMap keysMatchingThisForeignKey = keyProperty.getKeysMatchingThisForeignKey();
        DataTypeProperty oppositeForeignKey = (DataTypeProperty)keysMatchingThisForeignKey.get((Object)(opposite = associationEnd.getOpposite()));
        if (oppositeForeignKey != null) {
            Object result = this.mutationContext.getPropertyDataFromUrl().getIfAbsent((Object)oppositeForeignKey, (Function0 & Serializable)() -> this.dataStore.getDataTypeProperty(persistentParentInstance, oppositeForeignKey));
            return Objects.requireNonNull(result);
        }
        if (keysMatchingThisForeignKey.notEmpty()) {
            if (keysMatchingThisForeignKey.size() != 1) {
                throw new AssertionError();
            }
            Pair pair = (Pair)keysMatchingThisForeignKey.keyValuesView().getOnly();
            JsonNode childNode = jsonNode.path(((AssociationEnd)pair.getOne()).getName());
            if (childNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)childNode;
                Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)((DataTypeProperty)pair.getTwo()), (ObjectNode)objectNode);
                return Objects.requireNonNull(result);
            }
            if (jsonNode.has(keyProperty.getName()) && !keyProperty.isPrivate()) {
                return JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)keyProperty, (ObjectNode)((ObjectNode)jsonNode));
            }
            throw new AssertionError();
        }
        Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)keyProperty, (ObjectNode)((ObjectNode)jsonNode));
        return Objects.requireNonNull(result);
    }

    @Nonnull
    private MapIterable<MapIterable<DataTypeProperty, Object>, Object> indexPersistentInstances(@Nonnull List<Object> persistentInstances, @Nonnull Klass klass) {
        MutableOrderedMap result = OrderedMapAdapter.adapt(new LinkedHashMap());
        ListIterate.groupByUniqueKey(persistentInstances, (Function & Serializable)persistentInstance -> this.getKeysFromPersistentInstance(persistentInstance, klass), (MutableMapIterable)result);
        return result.asUnmodifiable();
    }

    private boolean jsonNodeNeedsIdInferredOnInsert(JsonNode jsonNode, @Nonnull AssociationEnd associationEnd) {
        return associationEnd.getType().getKeyProperties().allSatisfy((Predicate & Serializable)keyProperty -> this.jsonNodeNeedsIdInferredOnInsert((DataTypeProperty)keyProperty, jsonNode, associationEnd));
    }

    private boolean jsonNodeNeedsIdInferredOnInsert(@Nonnull DataTypeProperty keyProperty, JsonNode jsonNode, @Nonnull AssociationEnd associationEnd) {
        AssociationEnd opposite;
        OrderedMap keyMatchingThisForeignKey = keyProperty.getKeysMatchingThisForeignKey();
        if (keyMatchingThisForeignKey.containsKey((Object)(opposite = associationEnd.getOpposite()))) {
            return false;
        }
        if (keyMatchingThisForeignKey.notEmpty()) {
            if (keyMatchingThisForeignKey.size() != 1) {
                throw new AssertionError();
            }
            return false;
        }
        return JsonDataTypeValueVisitor.dataTypePropertyIsNullInJson((DataTypeProperty)keyProperty, (ObjectNode)((ObjectNode)jsonNode));
    }

    protected MapIterable<DataTypeProperty, Object> getKeysFromJsonNode(@Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, Object persistentParentInstance) {
        MutableMap result = MapAdapter.adapt(new LinkedHashMap());
        for (DataTypeProperty keyProperty : associationEnd.getType().getKeyProperties()) {
            if (!jsonNode.has(keyProperty.getName()) && this.jsonNodeNeedsIdInferredOnInsert(keyProperty, jsonNode, associationEnd)) continue;
            Object key = this.getKeyFromJsonNode(keyProperty, jsonNode, associationEnd, persistentParentInstance);
            result.put((Object)keyProperty, key);
        }
        return result.asUnmodifiable();
    }
}

