/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.persistent.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.data.store.DataStore;
import cool.klass.deserializer.json.AssertValuesMatchPropertyVisitor;
import cool.klass.deserializer.json.JsonDataTypeValueVisitor;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.PropertyVisitor;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.reladomo.persistent.writer.IncomingCreateDataModelValidator;
import cool.klass.reladomo.persistent.writer.MutationContext;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.OrderedMap;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.list.mutable.ListAdapter;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.eclipse.collections.impl.utility.ListIterate;

public class IncomingUpdateDataModelValidator {
    @Nonnull
    protected final DataStore dataStore;
    @Nonnull
    protected final Klass userKlass;
    @Nonnull
    protected final Klass klass;
    @Nonnull
    protected final MutationContext mutationContext;
    @Nonnull
    protected final Object persistentInstance;
    @Nonnull
    protected final ObjectNode objectNode;
    @Nonnull
    protected final MutableList<String> errors;
    @Nonnull
    protected final MutableList<String> warnings;
    @Nonnull
    protected final MutableStack<String> contextStack;
    @Nonnull
    protected final Optional<AssociationEnd> pathHere;
    protected final boolean isRoot;
    protected final boolean isInProjection;

    public IncomingUpdateDataModelValidator(@Nonnull DataStore dataStore, @Nonnull Klass userKlass, @Nonnull Klass klass, @Nonnull MutationContext mutationContext, @Nonnull Object persistentInstance, @Nonnull ObjectNode objectNode, @Nonnull MutableList<String> errors, @Nonnull MutableList<String> warnings, @Nonnull MutableStack<String> contextStack, @Nonnull Optional<AssociationEnd> pathHere, boolean isRoot, boolean isInProjection) {
        this.dataStore = Objects.requireNonNull(dataStore);
        this.userKlass = Objects.requireNonNull(userKlass);
        this.klass = Objects.requireNonNull(klass);
        this.mutationContext = Objects.requireNonNull(mutationContext);
        this.persistentInstance = Objects.requireNonNull(persistentInstance);
        this.objectNode = Objects.requireNonNull(objectNode);
        this.errors = Objects.requireNonNull(errors);
        this.warnings = Objects.requireNonNull(warnings);
        this.contextStack = Objects.requireNonNull(contextStack);
        this.pathHere = Objects.requireNonNull(pathHere);
        this.isRoot = isRoot;
        this.isInProjection = isInProjection;
    }

    public static void validate(@Nonnull DataStore dataStore, @Nonnull Klass userKlass, @Nonnull Klass klass, @Nonnull MutationContext mutationContext, @Nonnull Object persistentInstance, @Nonnull ObjectNode objectNode, @Nonnull MutableList<String> errors, @Nonnull MutableList<String> warnings) {
        IncomingUpdateDataModelValidator validator = new IncomingUpdateDataModelValidator(dataStore, userKlass, klass, mutationContext, persistentInstance, objectNode, errors, warnings, (MutableStack<String>)Stacks.mutable.empty(), Optional.empty(), true, true);
        validator.validate();
    }

    public void validate() {
        if (this.isRoot) {
            this.contextStack.push((Object)this.klass.getName());
        }
        try {
            this.handleDataTypePropertiesInsideProjection();
            this.handleAssociationEnds();
        }
        finally {
            if (this.isRoot) {
                this.contextStack.pop();
            }
        }
    }

    private void handleDataTypePropertiesInsideProjection() {
        ImmutableList dataTypeProperties = this.klass.getDataTypeProperties();
        for (DataTypeProperty dataTypeProperty : dataTypeProperties) {
            this.handleDataTypePropertyInsideProjection(dataTypeProperty);
        }
    }

    private void handleDataTypePropertyInsideProjection(@Nonnull DataTypeProperty dataTypeProperty) {
        if (dataTypeProperty.isKey()) {
            this.handleKeyProperty(dataTypeProperty);
        } else if (dataTypeProperty.isTemporalInstant()) {
            this.checkPropertyMatchesIfPresent(dataTypeProperty, "temporal");
        } else if (dataTypeProperty.isCreatedBy() || dataTypeProperty.isLastUpdatedBy()) {
            if (dataTypeProperty.isForeignKey()) {
                return;
            }
            this.handleAuditProperty(dataTypeProperty);
        } else if (dataTypeProperty.isCreatedOn()) {
            this.checkPropertyMatchesIfPresent(dataTypeProperty, "created on");
        } else if (dataTypeProperty.isVersion()) {
            this.checkPropertyMatchesIfPresent(dataTypeProperty, "version");
        } else if (dataTypeProperty.isFinal()) {
            this.checkPropertyMatchesIfPresent(dataTypeProperty, "final");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        this.contextStack.push((Object)dataTypeProperty.getName());
        try {
            JsonNode jsonDataTypeValue = this.objectNode.path(dataTypeProperty.getName());
            if (jsonDataTypeValue.isMissingNode()) {
                return;
            }
            ImmutableMap<DataTypeProperty, Object> propertyDataFromUrl = this.mutationContext.getPropertyDataFromUrl();
            if (!propertyDataFromUrl.containsKey((Object)dataTypeProperty)) {
                return;
            }
            Object propertyData = propertyDataFromUrl.get((Object)dataTypeProperty);
            AssertValuesMatchPropertyVisitor visitor = new AssertValuesMatchPropertyVisitor(jsonDataTypeValue, propertyData, "url parameter key", this.contextStack, "Error", this.errors);
            dataTypeProperty.visit((PropertyVisitor)visitor);
        }
        finally {
            this.contextStack.pop();
        }
    }

    private void handleAuditProperty(@Nonnull DataTypeProperty dataTypeProperty) {
        this.checkPropertyMatchesIfPresent(dataTypeProperty, "user id");
    }

    private void checkPropertyMatchesIfPresent(@Nonnull DataTypeProperty dataTypeProperty, @Nonnull String propertyKind) {
        this.contextStack.push((Object)dataTypeProperty.getName());
        try {
            this.checkPropertyMatches(dataTypeProperty, propertyKind);
        }
        finally {
            this.contextStack.pop();
        }
    }

    private void checkPropertyMatches(@Nonnull DataTypeProperty property, @Nonnull String propertyKind) {
        JsonNode jsonDataTypeValue = this.objectNode.path(property.getName());
        if (jsonDataTypeValue.isMissingNode()) {
            return;
        }
        Object persistentValue = this.dataStore.getDataTypeProperty(this.persistentInstance, property);
        AssertValuesMatchPropertyVisitor visitor = new AssertValuesMatchPropertyVisitor(jsonDataTypeValue, persistentValue, propertyKind, this.contextStack, "Error", this.errors);
        property.visit((PropertyVisitor)visitor);
    }

    public String getContextString() {
        return this.contextStack.toList().asReversed().makeString(".");
    }

    private void handleAssociationEnds() {
        for (AssociationEnd associationEnd : this.klass.getAssociationEnds()) {
            this.handleAssociationEnd(associationEnd);
        }
    }

    private void handleAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        if (this.isBackward(associationEnd)) {
            return;
        }
        if (associationEnd.isVersion()) {
            this.handleVersionAssociationEnd(associationEnd);
            return;
        }
        if (associationEnd.isCreatedBy() || associationEnd.isLastUpdatedBy()) {
            this.handleAuditByAssociationEnd(associationEnd);
            return;
        }
        Multiplicity multiplicity = associationEnd.getMultiplicity();
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            return;
        }
        if (multiplicity.isToOne()) {
            this.handleToOne(associationEnd, jsonNode);
        } else {
            this.handleToMany(associationEnd, jsonNode);
        }
    }

    private void handleAssociationEnd(@Nonnull AssociationEnd associationEnd, @Nonnull ObjectNode objectNode, @Nonnull Object persistentInstance) {
        IncomingUpdateDataModelValidator validator = new IncomingUpdateDataModelValidator(this.dataStore, this.userKlass, associationEnd.getType(), this.mutationContext, persistentInstance, objectNode, this.errors, this.warnings, this.contextStack, Optional.of(associationEnd), false, this.isInProjection && associationEnd.isOwned());
        validator.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAuditByAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (jsonNode.isMissingNode() || jsonNode.isNull()) {
            return;
        }
        String associationEndName = associationEnd.getName();
        this.contextStack.push((Object)associationEndName);
        Optional<String> userId = this.mutationContext.getUserId();
        if (userId.isEmpty()) {
            return;
        }
        DataTypeProperty userIdProperty = (DataTypeProperty)this.userKlass.getKeyProperties().getOnly();
        ImmutableMap userKeys = Maps.immutable.with((Object)userIdProperty, (Object)userId.get());
        Object userPersistentInstance = this.dataStore.findByKey(this.userKlass, (MapIterable)userKeys);
        if (userPersistentInstance == null) {
            String error = String.format("Error at %s. Couldn't find user with key %s.", this.getContextString(), userKeys);
            this.errors.add((Object)error);
            return;
        }
        try {
            IncomingCreateDataModelValidator validator = new IncomingCreateDataModelValidator(this.dataStore, this.userKlass, associationEnd.getType(), this.mutationContext, (ObjectNode)jsonNode, this.errors, this.warnings, this.contextStack, Optional.of(associationEnd), false);
            validator.validate();
        }
        finally {
            this.contextStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleVersionAssociationEnd(@Nonnull AssociationEnd associationEnd) {
        this.contextStack.push((Object)associationEnd.getName());
        try {
            JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
            if (this.persistentInstance == null) {
                this.handleWarnIfPresent(associationEnd, "version");
                return;
            }
            if (jsonNode.isMissingNode() || jsonNode.isNull()) {
                if (this.isInProjection && this.klass.getKeyProperties().noneSatisfy(DataTypeProperty::isID)) {
                    this.handleErrorIfAbsent(associationEnd, "version");
                }
                return;
            }
            Object childPersistentInstance = this.dataStore.getToOne(this.persistentInstance, (ReferenceProperty)associationEnd);
            if (!(jsonNode instanceof ObjectNode)) {
                return;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            this.handleAssociationEnd(associationEnd, objectNode, childPersistentInstance);
        }
        finally {
            this.contextStack.pop();
        }
    }

    private void handleErrorIfAbsent(@Nonnull AssociationEnd associationEnd, String propertyKind) {
        JsonNode jsonNode = this.objectNode.path(associationEnd.getName());
        if (!jsonNode.isMissingNode() && !jsonNode.isNull()) {
            return;
        }
        String error = String.format("Error at %s. Expected value for %s property '%s.%s: %s[%s]' but value was %s.", this.getContextString(), propertyKind, associationEnd.getOwningClassifier().getName(), associationEnd.getName(), associationEnd.getType(), associationEnd.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase());
        this.errors.add((Object)error);
    }

    private void handleWarnIfPresent(@Nonnull AssociationEnd property, String propertyKind) {
        JsonNode jsonNode = this.objectNode.path(property.getName());
        if (jsonNode.isMissingNode()) {
            return;
        }
        Object jsonNodeString = jsonNode.isNull() ? "" : ": " + jsonNode;
        String warning = String.format("Warning at %s. Didn't expect to receive value for %s association end '%s.%s: %s[%s]' but value was %s%s.", this.getContextString(), propertyKind, property.getOwningClassifier().getName(), property.getName(), property.getType(), property.getMultiplicity().getPrettyName(), jsonNode.getNodeType().toString().toLowerCase(), jsonNodeString);
        this.warnings.add((Object)warning);
    }

    private boolean isBackward(@Nonnull AssociationEnd associationEnd) {
        return this.pathHere.equals(Optional.of(associationEnd.getOpposite()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleToOne(@Nonnull AssociationEnd associationEnd, JsonNode jsonNode) {
        this.contextStack.push((Object)associationEnd.getName());
        try {
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                Object childPersistentInstance = this.dataStore.getToOne(this.persistentInstance, (ReferenceProperty)associationEnd);
                if (childPersistentInstance == null) {
                    return;
                }
                this.handleAssociationEnd(associationEnd, objectNode, childPersistentInstance);
            }
        }
        finally {
            this.contextStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleToMany(@Nonnull AssociationEnd associationEnd, JsonNode incomingChildInstances) {
        if (!(incomingChildInstances instanceof ArrayNode)) {
            this.emitNonArrayError(associationEnd, incomingChildInstances);
            return;
        }
        ImmutableList<JsonNode> incomingInstancesForUpdate = this.filterIncomingInstancesForUpdate(incomingChildInstances, associationEnd);
        MapIterable<ImmutableList<Object>, JsonNode> incomingChildInstancesByKey = this.indexIncomingJsonInstances((Iterable<JsonNode>)incomingInstancesForUpdate, associationEnd);
        MapIterable<ImmutableList<Object>, Object> persistentChildInstancesByKey = this.getPersistentChildInstancesByKey(incomingChildInstancesByKey, associationEnd);
        for (int index = 0; index < incomingChildInstances.size(); ++index) {
            String contextString = String.format("%s[%d]", associationEnd.getName(), index);
            this.contextStack.push((Object)contextString);
            try {
                JsonNode childJsonNode = incomingChildInstances.path(index);
                if (this.jsonNodeNeedsIdInferredOnInsert(childJsonNode, associationEnd)) continue;
                ImmutableList<Object> keysFromJsonNode = this.getKeysFromJsonNode(childJsonNode, associationEnd, (JsonNode)this.objectNode);
                Object childPersistentInstance = persistentChildInstancesByKey.get(keysFromJsonNode);
                if (childPersistentInstance == null) {
                    IncomingCreateDataModelValidator validator = new IncomingCreateDataModelValidator(this.dataStore, this.userKlass, associationEnd.getType(), this.mutationContext, (ObjectNode)childJsonNode, this.errors, this.warnings, this.contextStack, Optional.of(associationEnd), false);
                    validator.validate();
                    continue;
                }
                this.handleAssociationEnd(associationEnd, (ObjectNode)childJsonNode, childPersistentInstance);
                continue;
            }
            finally {
                this.contextStack.pop();
            }
        }
    }

    @Nonnull
    private MapIterable<ImmutableList<Object>, Object> getPersistentChildInstancesByKey(@Nonnull MapIterable<ImmutableList<Object>, JsonNode> incomingChildInstancesByKey, @Nonnull AssociationEnd associationEnd) {
        List persistentChildInstances = this.dataStore.getToMany(this.persistentInstance, (ReferenceProperty)associationEnd);
        MutableList nonTerminatedPersistentChildInstances = ListAdapter.adapt((List)persistentChildInstances).reject((Predicate & Serializable)persistentChildInstance -> this.needsTermination(persistentChildInstance, associationEnd.getType(), incomingChildInstancesByKey));
        return this.indexPersistentInstances((List<Object>)nonTerminatedPersistentChildInstances, associationEnd.getType());
    }

    private ImmutableList<JsonNode> filterIncomingInstancesForUpdate(JsonNode incomingChildInstances, AssociationEnd associationEnd) {
        return Lists.immutable.withAll((Iterable)incomingChildInstances).rejectWith(this::jsonNodeNeedsIdInferredOnInsert, (Object)associationEnd);
    }

    private ImmutableList<JsonNode> filterIncomingInstancesForInsert(JsonNode incomingChildInstances, AssociationEnd associationEnd) {
        return Lists.immutable.withAll((Iterable)incomingChildInstances).selectWith(this::jsonNodeNeedsIdInferredOnInsert, (Object)associationEnd);
    }

    private boolean needsTermination(Object persistentChildInstance, @Nonnull Klass klass, @Nonnull MapIterable<ImmutableList<Object>, JsonNode> incomingChildInstancesByKey) {
        ImmutableList<Object> keys = this.getKeysFromPersistentInstance(persistentChildInstance, klass);
        return !incomingChildInstancesByKey.containsKey(keys);
    }

    protected ImmutableList<Object> getKeysFromPersistentInstance(Object persistentInstance, @Nonnull Klass klass) {
        return klass.getKeyProperties().collect((Function & Serializable)keyProperty -> this.dataStore.getDataTypeProperty(persistentInstance, keyProperty));
    }

    private void emitNonArrayError(@Nonnull AssociationEnd associationEnd, @Nonnull JsonNode incomingChildInstances) {
        this.contextStack.push((Object)associationEnd.getName());
        String error = String.format("Error at %s. Expected json array but value was %s.", this.getContextString(), incomingChildInstances.getNodeType().toString().toLowerCase());
        this.errors.add((Object)error);
        this.contextStack.pop();
    }

    @Nonnull
    private MapIterable<ImmutableList<Object>, Object> indexPersistentInstances(@Nonnull List<Object> persistentInstances, @Nonnull Klass klass) {
        MutableOrderedMap result = (MutableOrderedMap)ListIterate.groupByUniqueKey(persistentInstances, (Function & Serializable)persistentInstance -> this.getKeysFromPersistentInstance(persistentInstance, klass), (MutableMapIterable)OrderedMapAdapter.adapt(new LinkedHashMap()));
        return result.asUnmodifiable();
    }

    @Nonnull
    private MapIterable<ImmutableList<Object>, JsonNode> indexIncomingJsonInstances(@Nonnull Iterable<JsonNode> incomingInstances, @Nonnull AssociationEnd associationEnd) {
        MutableOrderedMap result = OrderedMapAdapter.adapt(new LinkedHashMap());
        for (JsonNode incomingInstance : incomingInstances) {
            ImmutableList<Object> keys = this.getKeysFromJsonNode(incomingInstance, associationEnd, (JsonNode)this.objectNode);
            JsonNode duplicateJsonNode = (JsonNode)result.put(keys, (Object)incomingInstance);
            if (duplicateJsonNode != null) {
                throw new AssertionError((Object)"TODO: Test an array of owned children with duplicates with the same key.");
            }
        }
        return result.asUnmodifiable();
    }

    private boolean jsonNodeNeedsIdInferredOnInsert(JsonNode jsonNode, @Nonnull AssociationEnd associationEnd) {
        return associationEnd.getType().getKeyProperties().allSatisfy((Predicate & Serializable)keyProperty -> this.jsonNodeNeedsIdInferredOnInsert((DataTypeProperty)keyProperty, jsonNode, associationEnd));
    }

    private boolean jsonNodeNeedsIdInferredOnInsert(@Nonnull DataTypeProperty keyProperty, JsonNode jsonNode, @Nonnull AssociationEnd associationEnd) {
        AssociationEnd opposite;
        OrderedMap keyMatchingThisForeignKey = keyProperty.getKeysMatchingThisForeignKey();
        if (keyMatchingThisForeignKey.containsKey((Object)(opposite = associationEnd.getOpposite()))) {
            return false;
        }
        if (keyMatchingThisForeignKey.notEmpty()) {
            if (keyMatchingThisForeignKey.size() != 1) {
                throw new AssertionError();
            }
            return false;
        }
        return JsonDataTypeValueVisitor.dataTypePropertyIsNullInJson((DataTypeProperty)keyProperty, (ObjectNode)((ObjectNode)jsonNode));
    }

    private ImmutableList<Object> getKeysFromJsonNode(@Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, @Nonnull JsonNode parentJsonNode) {
        Klass type = associationEnd.getType();
        ImmutableList keyProperties = type.getKeyProperties();
        return keyProperties.collect((Function & Serializable)keyProperty -> this.getKeyFromJsonNode((DataTypeProperty)keyProperty, jsonNode, associationEnd, parentJsonNode));
    }

    private Object getKeyFromJsonNode(@Nonnull DataTypeProperty keyProperty, @Nonnull JsonNode jsonNode, @Nonnull AssociationEnd associationEnd, @Nonnull JsonNode parentJsonNode) {
        AssociationEnd opposite;
        OrderedMap keysMatchingThisForeignKey = keyProperty.getKeysMatchingThisForeignKey();
        DataTypeProperty oppositeForeignKeys = (DataTypeProperty)keysMatchingThisForeignKey.get((Object)(opposite = associationEnd.getOpposite()));
        if (oppositeForeignKeys != null) {
            Object result = this.dataStore.getDataTypeProperty(this.persistentInstance, oppositeForeignKeys);
            return Objects.requireNonNull(result);
        }
        if (keysMatchingThisForeignKey.notEmpty()) {
            if (keysMatchingThisForeignKey.size() != 1) {
                throw new AssertionError();
            }
            Pair pair = (Pair)keysMatchingThisForeignKey.keyValuesView().getOnly();
            AssociationEnd foreignKeyAssociation = (AssociationEnd)pair.getOne();
            String foreignKeyAssociationName = foreignKeyAssociation.getName();
            JsonNode childNode = jsonNode.path(foreignKeyAssociationName);
            if (childNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)childNode;
                Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)((DataTypeProperty)pair.getTwo()), (ObjectNode)objectNode);
                return Objects.requireNonNull(result);
            }
            if (childNode.isMissingNode()) {
                Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)keyProperty, (ObjectNode)((ObjectNode)jsonNode));
                return Objects.requireNonNull(result);
            }
            throw new AssertionError((Object)childNode.getClass().getCanonicalName());
        }
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Object result = JsonDataTypeValueVisitor.extractDataTypePropertyFromJson((DataTypeProperty)keyProperty, (ObjectNode)objectNode);
            return Objects.requireNonNull(result);
        }
        throw new AssertionError();
    }
}

