/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.persistent.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.data.store.DataStore;
import cool.klass.deserializer.json.OperationMode;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.reladomo.persistent.writer.MutationContext;
import cool.klass.reladomo.persistent.writer.PersistentSynchronizer;
import java.io.Serializable;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.map.mutable.MapAdapter;

public class PersistentCreator
extends PersistentSynchronizer {
    public PersistentCreator(@Nonnull MutationContext mutationContext, @Nonnull DataStore dataStore) {
        this(mutationContext, dataStore, false);
    }

    public PersistentCreator(@Nonnull MutationContext mutationContext, @Nonnull DataStore dataStore, boolean inTransaction) {
        super(mutationContext, dataStore, inTransaction);
    }

    @Override
    protected boolean shouldWriteKey() {
        return true;
    }

    @Override
    protected boolean shouldWriteId() {
        return false;
    }

    @Override
    protected void synchronizeUpdatedDataTypeProperties(@Nonnull Klass klass, Object persistentInstance, boolean propertyMutationOccurred) {
        this.synchronizeUpdatedDataTypeProperties(klass, persistentInstance);
    }

    @Override
    protected void validateSetIdDataTypeProperties(Klass klass, Object persistentInstance) {
        ImmutableList idProperties = klass.getDataTypeProperties().select(DataTypeProperty::isID);
        for (DataTypeProperty idProperty : idProperties) {
            Object id = this.dataStore.getDataTypeProperty(persistentInstance, idProperty);
            if (!id.equals(0L) && !id.equals(0)) continue;
            throw new IllegalStateException();
        }
    }

    @Override
    protected void synchronizeCreatedDataTypeProperties(@Nonnull Klass klass, Object persistentInstance) {
        Optional createdByProperty = klass.getCreatedByProperty();
        Optional createdOnProperty = klass.getCreatedOnProperty();
        createdByProperty.ifPresent(primitiveProperty -> {
            Optional<String> optionalUserId = this.mutationContext.getUserId();
            String userId = optionalUserId.orElseThrow(() -> this.expectAuditProperty((PrimitiveProperty)primitiveProperty));
            if (!this.dataStore.setDataTypeProperty(persistentInstance, (DataTypeProperty)primitiveProperty, (Object)userId)) {
                String detailMessage = "Expected to set createdBy property: %s on %s to %s".formatted(primitiveProperty, persistentInstance, userId);
                throw new AssertionError((Object)detailMessage);
            }
        });
        createdOnProperty.ifPresent(primitiveProperty -> {
            Instant transactionTime = this.mutationContext.getTransactionTime();
            if (!this.dataStore.setDataTypeProperty(persistentInstance, (DataTypeProperty)primitiveProperty, (Object)transactionTime)) {
                String detailMessage = "Expected to set createdOn property: %s on %s to %s".formatted(primitiveProperty, persistentInstance, transactionTime);
                throw new AssertionError((Object)detailMessage);
            }
        });
    }

    private AssertionError expectAuditProperty(PrimitiveProperty primitiveProperty) {
        String message = String.format("Mutation context has no userId, but found an audit property: '%s'", primitiveProperty);
        return new AssertionError((Object)message);
    }

    @Override
    protected void handleVersion(@Nonnull AssociationEnd associationEnd, Object persistentInstance) {
        Object persistentChildInstance = this.dataStore.getToOne(persistentInstance, (ReferenceProperty)associationEnd);
        if (persistentChildInstance != null) {
            throw new AssertionError();
        }
        ImmutableMap<DataTypeProperty, Object> keys = this.getKeysFromPersistentInstance(persistentInstance, associationEnd.getOwningClassifier());
        MutableMap<DataTypeProperty, Object> versionKeys = PersistentCreator.getVersionKeys(associationEnd, keys);
        this.insertVersion(persistentInstance, associationEnd, (MapIterable<DataTypeProperty, Object>)versionKeys);
    }

    @Nonnull
    private static MutableMap<DataTypeProperty, Object> getVersionKeys(@Nonnull AssociationEnd associationEnd, ImmutableMap<DataTypeProperty, Object> keys) {
        MutableMap versionKeys = MapAdapter.adapt(new LinkedHashMap());
        keys.forEachKeyValue((Procedure2 & Serializable)(keyProperty, keyValue) -> {
            DataTypeProperty versionKeyProperty = PersistentCreator.getVersionKeyProperty(associationEnd, keyProperty);
            versionKeys.put((Object)versionKeyProperty, keyValue);
        });
        return versionKeys;
    }

    @Nonnull
    private static DataTypeProperty getVersionKeyProperty(@Nonnull AssociationEnd associationEnd, DataTypeProperty keyProperty) {
        DataTypeProperty versionKeyProperty = (DataTypeProperty)keyProperty.getForeignKeysMatchingThisKey().get((Object)associationEnd.getOpposite());
        if (versionKeyProperty.getOwningClassifier() == associationEnd.getType()) {
            return versionKeyProperty;
        }
        String message = "Expected version key property '%s' to be owned by '%s' but it's owned by '%s' instead.".formatted(versionKeyProperty, associationEnd.getType(), versionKeyProperty.getOwningClassifier());
        throw new AssertionError((Object)message);
    }

    @Override
    protected boolean handleToOneOutsideProjection(@Nonnull AssociationEnd associationEnd, @Nonnull Object persistentParentInstance, @Nonnull ObjectNode incomingParentNode, @Nonnull JsonNode incomingChildInstance) {
        if (associationEnd.isOwned()) {
            throw new AssertionError((Object)"Assumption is that all owned association ends are inside projection, all unowned are outside projection");
        }
        if (incomingChildInstance.isMissingNode() || incomingChildInstance.isNull()) {
            return false;
        }
        Object childPersistentInstanceWithKey = this.findExistingChildPersistentInstance(persistentParentInstance, incomingChildInstance, associationEnd);
        if (childPersistentInstanceWithKey == null) {
            return false;
        }
        this.dataStore.setToOne(persistentParentInstance, associationEnd, childPersistentInstanceWithKey);
        return true;
    }

    private void insertVersion(Object persistentInstance, @Nonnull AssociationEnd associationEnd, @Nonnull MapIterable<DataTypeProperty, Object> keys) {
        Klass versionType = associationEnd.getType();
        Object versionInstance = this.dataStore.instantiate(versionType, keys);
        DataTypeProperty versionProperty = (DataTypeProperty)versionType.getVersionNumberProperty().get();
        this.dataStore.setDataTypeProperty(versionInstance, versionProperty, (Object)1);
        this.synchronizeCreatedDataTypeProperties(versionType, versionInstance);
        this.synchronizeUpdatedDataTypeProperties(versionType, versionInstance);
        this.dataStore.setToOne(persistentInstance, associationEnd, versionInstance);
        this.dataStore.insert(versionInstance);
    }

    @Override
    @Nonnull
    protected PersistentSynchronizer determineNextMode(OperationMode nextMode) {
        if (nextMode == OperationMode.CREATE) {
            return new PersistentCreator(this.mutationContext, this.dataStore, this.inTransaction);
        }
        throw new AssertionError(nextMode);
    }
}

