/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.persistent.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cool.klass.data.store.DataStore;
import cool.klass.deserializer.json.OperationMode;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.reladomo.persistent.writer.MutationContext;
import cool.klass.reladomo.persistent.writer.PersistentCreator;
import cool.klass.reladomo.persistent.writer.PersistentSynchronizer;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.map.MapIterable;

public class PersistentPatcher
extends PersistentSynchronizer {
    public PersistentPatcher(@Nonnull MutationContext mutationContext, @Nonnull DataStore dataStore) {
        this(mutationContext, dataStore, false);
    }

    public PersistentPatcher(@Nonnull MutationContext mutationContext, @Nonnull DataStore dataStore, boolean inTransaction) {
        super(mutationContext, dataStore, inTransaction);
    }

    @Override
    protected boolean shouldWriteKey() {
        return false;
    }

    @Override
    protected boolean shouldWriteId() {
        return true;
    }

    @Override
    protected void synchronizeUpdatedDataTypeProperties(@Nonnull Klass klass, Object persistentInstance, boolean propertyMutationOccurred) {
        if (propertyMutationOccurred) {
            this.synchronizeUpdatedDataTypeProperties(klass, persistentInstance);
        }
    }

    @Override
    protected void validateSetIdDataTypeProperties(Klass klass, Object persistentInstance) {
    }

    @Override
    protected void synchronizeCreatedDataTypeProperties(Klass klass, Object persistentInstance) {
    }

    @Override
    protected boolean synchronizeDataTypeProperty(@Nonnull DataTypeProperty dataTypeProperty, Object persistentInstance, @Nonnull ObjectNode incomingJson) {
        Object newValue = this.mutationContext.getPropertyDataFromUrl().get((Object)dataTypeProperty);
        if (newValue != null) {
            return this.dataStore.setDataTypeProperty(persistentInstance, dataTypeProperty, newValue);
        }
        JsonNode jsonDataTypeValue = incomingJson.path(dataTypeProperty.getName());
        if (jsonDataTypeValue.isMissingNode()) {
            return false;
        }
        return super.synchronizeDataTypeProperty(dataTypeProperty, persistentInstance, incomingJson);
    }

    @Override
    protected void handleVersion(AssociationEnd associationEnd, Object persistentInstance) {
        Object versionPersistentInstance = this.dataStore.getToOne(persistentInstance, (ReferenceProperty)associationEnd);
        DataTypeProperty versionProperty = (DataTypeProperty)associationEnd.getType().getDataTypeProperties().select(DataTypeProperty::isVersion).getOnly();
        Integer versionNumber = (Integer)this.dataStore.getDataTypeProperty(versionPersistentInstance, versionProperty);
        this.dataStore.setDataTypeProperty(versionPersistentInstance, versionProperty, (Object)(versionNumber + 1));
    }

    @Override
    protected boolean handleMissingToOne(Klass klass, Object persistentChildInstance) {
        return false;
    }

    @Override
    protected boolean handleToMany(@Nonnull AssociationEnd associationEnd, Object persistentParentInstance, @Nonnull JsonNode incomingChildInstances) {
        if (incomingChildInstances.isMissingNode()) {
            return false;
        }
        return super.handleToMany(associationEnd, persistentParentInstance, incomingChildInstances);
    }

    @Override
    protected boolean handleToOneOutsideProjection(@Nonnull AssociationEnd associationEnd, @Nonnull Object persistentParentInstance, @Nonnull ObjectNode incomingParentNode, @Nonnull JsonNode incomingChildInstance) {
        if (associationEnd.isOwned()) {
            throw new AssertionError((Object)"Assumption is that all owned association ends are inside projection, all unowned are outside projection");
        }
        if (incomingChildInstance.isMissingNode() || incomingChildInstance.isNull()) {
            return false;
        }
        Object childPersistentInstanceAssociated = this.dataStore.getToOne(persistentParentInstance, (ReferenceProperty)associationEnd);
        Object childPersistentInstanceWithKey = this.findExistingChildPersistentInstance(persistentParentInstance, incomingChildInstance, associationEnd);
        if (childPersistentInstanceWithKey == null) {
            MapIterable<DataTypeProperty, Object> keys = this.getKeysFromJsonNode(incomingChildInstance, associationEnd, persistentParentInstance);
            String error = String.format("Could not find existing %s with key %s", associationEnd.getType(), keys);
            throw new IllegalStateException(error);
        }
        if (childPersistentInstanceAssociated == childPersistentInstanceWithKey) {
            return false;
        }
        if (associationEnd.isFinal()) {
            throw new AssertionError();
        }
        return this.dataStore.setToOne(persistentParentInstance, associationEnd, childPersistentInstanceWithKey);
    }

    @Override
    @Nonnull
    protected PersistentSynchronizer determineNextMode(OperationMode nextMode) {
        if (nextMode == OperationMode.REPLACE) {
            return new PersistentPatcher(this.mutationContext, this.dataStore, this.inTransaction);
        }
        if (nextMode == OperationMode.CREATE) {
            return new PersistentCreator(this.mutationContext, this.dataStore, this.inTransaction);
        }
        throw new AssertionError(nextMode);
    }
}

