/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.sample.data;

import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.AssociationEnd;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.SortedBags;

public abstract class AbstractDataTypePropertyVisitor
implements DataTypePropertyVisitor {
    private final MutableSortedBag<DataTypeProperty> propertyCounts = SortedBags.mutable.empty(AbstractDataTypePropertyVisitor.getDataTypePropertyComparator());
    private Object result;

    private static Comparator<DataTypeProperty> getDataTypePropertyComparator() {
        Comparator<DataTypeProperty> byClassifierName = Comparator.comparing(dtp -> dtp.getOwningClassifier().getName());
        return byClassifierName.thenComparing(NamedElement::getName);
    }

    public Object getResult() {
        return this.result;
    }

    public void visitEnumerationProperty(@Nonnull EnumerationProperty enumerationProperty) {
        ImmutableList enumerationLiterals = enumerationProperty.getType().getEnumerationLiterals();
        this.result = enumerationLiterals.get(this.getIndex() - 1);
    }

    public void visitString(@Nonnull PrimitiveProperty primitiveProperty) {
        if (primitiveProperty.getKeysMatchingThisForeignKey().size() > 1) {
            throw new AssertionError(primitiveProperty);
        }
        if (primitiveProperty.getKeysMatchingThisForeignKey().size() == 1) {
            Pair pair = (Pair)primitiveProperty.getKeysMatchingThisForeignKey().keyValuesView().getOnly();
            AssociationEnd associationEnd = (AssociationEnd)pair.getOne();
            DataTypeProperty keyProperty = (DataTypeProperty)pair.getTwo();
            this.result = String.format("%s %s %d %s", associationEnd.getType().getName(), keyProperty.getName(), this.getIndex(), this.getEmoji());
        } else {
            this.result = String.format("%s %s %d %s", primitiveProperty.getOwningClassifier().getName(), primitiveProperty.getName(), this.getNumber((DataTypeProperty)primitiveProperty), this.getEmoji());
        }
    }

    public void visitInteger(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = this.getAdjustment(primitiveProperty);
    }

    public void visitLong(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = primitiveProperty.isForeignKey() ? Long.valueOf(this.getIndex()) : (primitiveProperty.isKey() ? Long.valueOf(this.getNumber((DataTypeProperty)primitiveProperty)) : Long.valueOf(100000000000L * (long)this.getNumber((DataTypeProperty)primitiveProperty)));
    }

    public void visitDouble(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = (double)this.getAdjustment(primitiveProperty) + 0.0123456789;
    }

    public void visitFloat(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = Float.valueOf((float)this.getAdjustment(primitiveProperty) + 0.01234567f);
    }

    public void visitBoolean(PrimitiveProperty primitiveProperty) {
        this.result = this.getBoolean();
    }

    public void visitInstant(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = this.getUniqueLocalDateTime(primitiveProperty).toInstant(ZoneOffset.UTC);
    }

    public void visitLocalDate(@Nonnull PrimitiveProperty primitiveProperty) {
        this.result = this.getUniqueLocalDateTime(primitiveProperty).toLocalDate();
    }

    public void visitTemporalInstant(PrimitiveProperty primitiveProperty) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".visitTemporalInstant() not implemented yet");
    }

    public void visitTemporalRange(@Nonnull PrimitiveProperty primitiveProperty) {
        if (!primitiveProperty.isSystem()) {
            throw new AssertionError();
        }
    }

    protected abstract boolean getBoolean();

    @Nonnull
    protected abstract String getEmoji();

    protected abstract int getIndex();

    @Nonnull
    protected abstract LocalDateTime getLocalDateTime();

    private int getAdjustment(@Nonnull PrimitiveProperty primitiveProperty) {
        return primitiveProperty.isForeignKey() ? this.getIndex() : this.getNumber((DataTypeProperty)primitiveProperty);
    }

    private LocalDateTime getUniqueLocalDateTime(@Nonnull PrimitiveProperty primitiveProperty) {
        if (primitiveProperty.isForeignKey()) {
            return this.getLocalDateTime();
        }
        int occurrences = this.propertyCounts.occurrencesOf((Object)primitiveProperty);
        return this.getLocalDateTime().plus(occurrences, ChronoUnit.YEARS);
    }

    private int getNumber(DataTypeProperty dataTypeProperty) {
        int occurrences = this.propertyCounts.addOccurrences((Object)dataTypeProperty, 1);
        int oldOccurrences = occurrences - 1;
        return oldOccurrences * 2 + this.getIndex();
    }
}

