/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.sample.data;

import cool.klass.data.store.DataStore;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;

public abstract class AbstractKlassDataGenerator {
    @Nonnull
    protected final DataStore dataStore;

    protected AbstractKlassDataGenerator(@Nonnull DataStore dataStore) {
        this.dataStore = Objects.requireNonNull(dataStore);
    }

    protected abstract Object getNonNullValue(@Nonnull DataTypeProperty var1);

    protected abstract void generateIfRequired(Object var1, @Nonnull DataTypeProperty var2);

    public void generateIfRequired(@Nonnull Klass klass) {
        Object persistentInstance = this.instantiate(klass);
        klass.getDataTypeProperties().reject(DataTypeProperty::isKey).reject(DataTypeProperty::isSystem).reject(DataTypeProperty::isDerived).each((Procedure & Serializable)dataTypeProperty -> this.generateIfRequired(persistentInstance, (DataTypeProperty)dataTypeProperty));
        this.dataStore.insert(persistentInstance);
    }

    @Nonnull
    private Object instantiate(@Nonnull Klass klass) {
        ImmutableList keyProperties = klass.getKeyProperties().reject(DataTypeProperty::isID);
        ImmutableMap keyValues = keyProperties.toImmutableMap((Function & Serializable)keyProperty -> keyProperty, this::getNonNullValue);
        if (klass.isValidTemporal()) {
            throw new AssertionError();
        }
        return this.dataStore.instantiate(klass, (MapIterable)keyValues);
    }

    protected final void generate(Object persistentInstance, @Nonnull DataTypeProperty dataTypeProperty) {
        if (dataTypeProperty.isVersion()) {
            this.dataStore.setDataTypeProperty(persistentInstance, dataTypeProperty, (Object)1);
            return;
        }
        Object value = this.getNonNullValue(dataTypeProperty);
        this.dataStore.setDataTypeProperty(persistentInstance, dataTypeProperty, value);
    }
}

