/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.tree.deep.fetcher;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.gs.fw.common.mithra.finder.AbstractRelatedFinder;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.finder.DomainList;
import com.gs.fw.finder.Navigation;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.reladomo.tree.DataTypePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferencePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferenceReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.SubClassReladomoTreeNode;
import cool.klass.model.reladomo.tree.SuperClassReladomoTreeNode;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public class ReladomoTreeNodeDeepFetcherListener
implements ReladomoTreeNodeListener {
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final MutableStack<RelatedFinder<?>> stack = new ArrayStack();
    private final MutableStack<NamedElement> contextStack = new ArrayStack();
    private final ReladomoDataStore dataStore;
    private final DomainList domainList;
    private final Klass klass;

    public ReladomoTreeNodeDeepFetcherListener(ReladomoDataStore dataStore, DomainList domainList, Klass klass) {
        this.dataStore = dataStore;
        this.domainList = domainList;
        this.klass = klass;
    }

    public void assertInvariants() {
        if (this.stack.size() == this.contextStack.size()) {
            return;
        }
        String detailMessage = "Expected " + this.stack.size() + " but got " + this.contextStack.size();
        throw new AssertionError((Object)detailMessage);
    }

    public void enterRoot(RootReladomoTreeNode rootReladomoTreeNode) {
        if (this.klass != rootReladomoTreeNode.getOwningClassifier()) {
            String detailMessage = "Expected " + String.valueOf(this.klass) + " but got " + String.valueOf(rootReladomoTreeNode.getOwningClassifier());
            throw new AssertionError((Object)detailMessage);
        }
        AbstractRelatedFinder relatedFinder = this.dataStore.getRelatedFinder(rootReladomoTreeNode.getOwningClassifier());
        this.stack.push((Object)relatedFinder);
        this.contextStack.push((Object)rootReladomoTreeNode.getOwningClassifier());
    }

    public void exitRoot(RootReladomoTreeNode rootReladomoTreeNode) {
        this.stack.pop();
        this.contextStack.pop();
    }

    public void enterDataTypeProperty(DataTypePropertyReladomoTreeNode dataTypePropertyReladomoTreeNode) {
    }

    public void exitDataTypeProperty(DataTypePropertyReladomoTreeNode dataTypePropertyReladomoTreeNode) {
    }

    public void enterSuperClass(SuperClassReladomoTreeNode superClassReladomoTreeNode) {
        Klass superClass = superClassReladomoTreeNode.getType();
        String relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        RelatedFinder nextFinder = relatedFinder.getRelationshipFinderByName(relationshipName);
        this.stack.push((Object)nextFinder);
        this.contextStack.push((Object)superClass);
    }

    public void exitSuperClass(SuperClassReladomoTreeNode superClassReladomoTreeNode) {
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        Navigation navigation = (Navigation)relatedFinder;
        this.domainList.deepFetch(navigation);
        this.stack.pop();
        this.contextStack.pop();
    }

    public void enterSubClass(SubClassReladomoTreeNode subClassReladomoTreeNode) {
        Klass subClass = subClassReladomoTreeNode.getType();
        String relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)subClass.getName()) + "SubClass";
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        RelatedFinder nextFinder = relatedFinder.getRelationshipFinderByName(relationshipName);
        this.stack.push((Object)nextFinder);
        this.contextStack.push((Object)subClass);
    }

    public void exitSubClass(SubClassReladomoTreeNode subClassReladomoTreeNode) {
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        Navigation navigation = (Navigation)relatedFinder;
        this.domainList.deepFetch(navigation);
        this.stack.pop();
        this.contextStack.pop();
    }

    public void enterReferenceProperty(ReferencePropertyReladomoTreeNode referencePropertyReladomoTreeNode) {
        ReferenceProperty referenceProperty = referencePropertyReladomoTreeNode.getReferenceProperty();
        String propertyName = referenceProperty.getName();
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        RelatedFinder nextFinder = relatedFinder.getRelationshipFinderByName(propertyName);
        this.stack.push((Object)nextFinder);
        this.contextStack.push((Object)referenceProperty);
    }

    public void exitReferenceProperty(ReferencePropertyReladomoTreeNode referencePropertyReladomoTreeNode) {
        RelatedFinder relatedFinder = (RelatedFinder)this.stack.peek();
        Navigation navigation = (Navigation)relatedFinder;
        this.domainList.deepFetch(navigation);
        this.stack.pop();
        this.contextStack.pop();
    }

    public void enterReference(ReferenceReladomoTreeNode referenceReladomoTreeNode) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterReference() not implemented yet");
    }

    public void exitReference(ReferenceReladomoTreeNode referenceReladomoTreeNode) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".exitReference() not implemented yet");
    }
}

