/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.tree.serializer;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.gs.fw.common.mithra.MithraObject;
import com.gs.fw.common.mithra.finder.AbstractRelatedFinder;
import com.gs.fw.common.mithra.finder.RelatedFinder;
import com.gs.fw.finder.DomainList;
import cool.klass.data.store.reladomo.ReladomoDataStore;
import cool.klass.model.meta.domain.api.Classifier;
import cool.klass.model.meta.domain.api.Klass;
import cool.klass.model.meta.domain.api.Multiplicity;
import cool.klass.model.meta.domain.api.property.DataTypeProperty;
import cool.klass.model.meta.domain.api.property.ReferenceProperty;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import cool.klass.model.reladomo.tree.DataTypePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferencePropertyReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReferenceReladomoTreeNode;
import cool.klass.model.reladomo.tree.ReladomoTreeNodeToManyAwareListener;
import cool.klass.model.reladomo.tree.RootReladomoTreeNode;
import cool.klass.model.reladomo.tree.SubClassReladomoTreeNode;
import cool.klass.model.reladomo.tree.SuperClassReladomoTreeNode;
import cool.klass.reladomo.tree.serializer.ReflectionCache;
import cool.klass.reladomo.tree.serializer.ReflectionSetterDataTypePropertyVisitor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public class ReladomoTreeObjectToDTOSerializerListener
implements ReladomoTreeNodeToManyAwareListener {
    private static final Converter<String, String> LOWER_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final Converter<String, String> UPPER_TO_LOWER_CAMEL = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final ReflectionCache reflectionCache = new ReflectionCache();
    private final MutableStack<Object> contextStack = new ArrayStack();
    private final MutableStack<AbstractRelatedFinder> finderStack = new ArrayStack();
    private final MutableStack<Object> persistentInstanceStack = new ArrayStack();
    private final MutableStack<Object> resultNodeStack = new ArrayStack();
    private final ReladomoDataStore dataStore;
    private final DomainList domainList;
    private final Klass klass;
    private final MutableList<Object> result = Lists.mutable.empty();

    public ReladomoTreeObjectToDTOSerializerListener(ReladomoDataStore dataStore, DomainList domainList, Klass klass) {
        this.dataStore = Objects.requireNonNull(dataStore);
        this.domainList = Objects.requireNonNull(domainList);
        this.klass = Objects.requireNonNull(klass);
    }

    public MutableList<Object> getResult() {
        return this.result;
    }

    public Object getStateToAssertInvariants() {
        return new State((ImmutableStack<Object>)this.contextStack.toImmutable(), (ImmutableStack<AbstractRelatedFinder>)this.finderStack.toImmutable(), (ImmutableStack<Object>)this.persistentInstanceStack.toImmutable(), (ImmutableStack<Object>)this.resultNodeStack.toImmutable());
    }

    public void enterListIndex(int index) {
        Object persistentInstance = this.persistentInstanceStack.peek();
        if (!(persistentInstance instanceof List)) {
            String detailMessage = "Expected List but found: " + persistentInstance.getClass().getCanonicalName();
            throw new AssertionError((Object)detailMessage);
        }
        List persistentList = (List)persistentInstance;
        Object nextPersistentInstance = persistentList.get(index);
        Classifier classifierFromContext = this.getClassifierFromPersistentInstance(nextPersistentInstance);
        Object nextResultNode = this.instantiateDTO(classifierFromContext);
        MutableList resultNode = (MutableList)this.resultNodeStack.peek();
        resultNode.add(nextResultNode);
        this.contextStack.push((Object)index);
        this.persistentInstanceStack.push(nextPersistentInstance);
        this.resultNodeStack.push(nextResultNode);
    }

    public void exitListIndex(int index) {
        this.contextStack.pop();
        this.persistentInstanceStack.pop();
        this.resultNodeStack.pop();
    }

    public Optional<Integer> enterRoot(RootReladomoTreeNode rootReladomoTreeNode) {
        if (this.klass != rootReladomoTreeNode.getOwningClassifier()) {
            String detailMessage = "Expected " + String.valueOf(this.klass) + " but got " + String.valueOf(rootReladomoTreeNode.getOwningClassifier());
            throw new AssertionError((Object)detailMessage);
        }
        AbstractRelatedFinder relatedFinder = this.dataStore.getRelatedFinder(rootReladomoTreeNode.getOwningClassifier());
        this.contextStack.push((Object)rootReladomoTreeNode.getOwningClassifier());
        this.finderStack.push((Object)relatedFinder);
        this.persistentInstanceStack.push((Object)this.domainList);
        this.resultNodeStack.push(this.result);
        return Optional.of(this.domainList.size());
    }

    public void exitRoot(RootReladomoTreeNode rootReladomoTreeNode) {
        this.contextStack.pop();
        this.finderStack.pop();
        this.persistentInstanceStack.pop();
        this.resultNodeStack.pop();
    }

    public void enterDataTypeProperty(DataTypePropertyReladomoTreeNode dataTypePropertyReladomoTreeNode) {
        DataTypeProperty dataTypeProperty = dataTypePropertyReladomoTreeNode.getDataTypeProperty();
        this.contextStack.push((Object)dataTypeProperty);
        Object persistentInstance = this.persistentInstanceStack.peek();
        if (persistentInstance == null) {
            return;
        }
        Object resultNode = this.resultNodeStack.peek();
        Object data = this.dataStore.getDataTypeProperty(persistentInstance, dataTypeProperty);
        if (data == null) {
            return;
        }
        ReflectionSetterDataTypePropertyVisitor dataTypePropertyVisitor = new ReflectionSetterDataTypePropertyVisitor(this.reflectionCache, resultNode, data);
        dataTypeProperty.visit((DataTypePropertyVisitor)dataTypePropertyVisitor);
    }

    public void exitDataTypeProperty(DataTypePropertyReladomoTreeNode dataTypePropertyReladomoTreeNode) {
        this.contextStack.pop();
    }

    public void enterSuperClass(SuperClassReladomoTreeNode superClassReladomoTreeNode) {
        Klass owningClassifier = superClassReladomoTreeNode.getOwningClassifier();
        Klass superClass = superClassReladomoTreeNode.getType();
        String relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)superClass.getName()) + "SuperClass";
        RelatedFinder relatedFinder = (RelatedFinder)this.finderStack.peek();
        AbstractRelatedFinder nextFinder = (AbstractRelatedFinder)relatedFinder.getRelationshipFinderByName(relationshipName);
        Object persistentInstance = this.persistentInstanceStack.peek();
        Object superClassPersistentInstance = this.dataStore.getSuperClass(persistentInstance, owningClassifier);
        this.contextStack.push((Object)superClass);
        this.finderStack.push((Object)nextFinder);
        this.persistentInstanceStack.push(superClassPersistentInstance);
    }

    public void exitSuperClass(SuperClassReladomoTreeNode superClassReladomoTreeNode) {
        this.contextStack.pop();
        this.finderStack.pop();
        this.persistentInstanceStack.pop();
    }

    public void enterSubClass(SubClassReladomoTreeNode subClassReladomoTreeNode) {
        Klass owningClassifier = subClassReladomoTreeNode.getOwningClassifier();
        Klass subClass = subClassReladomoTreeNode.getType();
        String relationshipName = (String)UPPER_TO_LOWER_CAMEL.convert((Object)subClass.getName()) + "SubClass";
        RelatedFinder relatedFinder = (RelatedFinder)this.finderStack.peek();
        AbstractRelatedFinder nextFinder = (AbstractRelatedFinder)relatedFinder.getRelationshipFinderByName(relationshipName);
        Object persistentInstance = this.persistentInstanceStack.peek();
        MithraObject subClassPersistentInstance = this.dataStore.getSubClassPersistentInstance(owningClassifier, subClass, (MithraObject)persistentInstance);
        this.contextStack.push((Object)subClass);
        this.finderStack.push((Object)nextFinder);
        this.persistentInstanceStack.push((Object)subClassPersistentInstance);
    }

    public void exitSubClass(SubClassReladomoTreeNode subClassReladomoTreeNode) {
        this.contextStack.pop();
        this.finderStack.pop();
        this.persistentInstanceStack.pop();
    }

    public Optional<Integer> enterReferenceProperty(ReferencePropertyReladomoTreeNode referencePropertyReladomoTreeNode) {
        ReferenceProperty referenceProperty = referencePropertyReladomoTreeNode.getReferenceProperty();
        this.contextStack.push((Object)referenceProperty);
        String propertyName = referenceProperty.getName();
        RelatedFinder relatedFinder = (RelatedFinder)this.finderStack.peek();
        AbstractRelatedFinder nextFinder = (AbstractRelatedFinder)relatedFinder.getRelationshipFinderByName(propertyName);
        this.finderStack.push((Object)nextFinder);
        Object persistentInstance = this.persistentInstanceStack.peek();
        Object resultNode = this.resultNodeStack.peek();
        Object nextPersistentInstance = this.dataStore.get(persistentInstance, referenceProperty);
        this.persistentInstanceStack.push(nextPersistentInstance);
        if (nextPersistentInstance == null) {
            this.resultNodeStack.push(null);
            return Optional.of(0);
        }
        Multiplicity multiplicity = referenceProperty.getMultiplicity();
        if (multiplicity.isToOne()) {
            Classifier classifierFromContext = this.getClassifierFromPersistentInstance(nextPersistentInstance);
            Object nextResultNode = this.instantiateDTO(classifierFromContext);
            this.resultNodeStack.push(nextResultNode);
            this.setChildProperty(referenceProperty, resultNode, nextResultNode);
            return Optional.empty();
        }
        if (multiplicity.isToMany()) {
            MutableList nextResultNode = Lists.mutable.empty();
            this.setChildProperty(referenceProperty, resultNode, nextResultNode);
            this.resultNodeStack.push((Object)nextResultNode);
            List toMany = (List)nextPersistentInstance;
            return Optional.of(toMany.size());
        }
        throw new AssertionError((Object)("Unknown multiplicity: " + String.valueOf(multiplicity)));
    }

    public void exitReferenceProperty(ReferencePropertyReladomoTreeNode referencePropertyReladomoTreeNode) {
        this.contextStack.pop();
        this.finderStack.pop();
        this.persistentInstanceStack.pop();
        this.resultNodeStack.pop();
    }

    public Optional<Integer> enterReference(ReferenceReladomoTreeNode referenceReladomoTreeNode) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".enterReference() not implemented yet");
    }

    public void exitReference(ReferenceReladomoTreeNode referenceReladomoTreeNode) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".exitReference() not implemented yet");
    }

    @Nonnull
    private Classifier getClassifierFromPersistentInstance(Object nextPersistentInstance) {
        Klass klassFromContext = this.getKlassFromContext();
        Klass mostSpecificSubclass = this.dataStore.getMostSpecificSubclass(nextPersistentInstance, klassFromContext);
        if (mostSpecificSubclass.isAbstract()) {
            String detailMessage = "Cannot instantiate abstract class: " + String.valueOf(mostSpecificSubclass);
            throw new AssertionError((Object)detailMessage);
        }
        return mostSpecificSubclass;
    }

    @Nonnull
    private Klass getKlassFromContext() {
        Object context = this.contextStack.peek();
        if (context instanceof ReferenceProperty) {
            ReferenceProperty referenceProperty = (ReferenceProperty)context;
            return (Klass)referenceProperty.getType();
        }
        if (context instanceof Classifier) {
            Classifier classifier = (Classifier)context;
            return (Klass)classifier;
        }
        throw new AssertionError((Object)("Unknown context: " + String.valueOf(context)));
    }

    private void setChildProperty(ReferenceProperty referenceProperty, Object resultNode, Object nextResultNode) {
        String methodName = "set" + (String)LOWER_TO_UPPER_CAMEL.convert((Object)referenceProperty.getName());
        Class<?> resultNodeClass = resultNode.getClass();
        Class<?> nextResultNodeClass = this.getNextResultNodeClass(referenceProperty);
        try {
            Method method = this.reflectionCache.getMethod(resultNodeClass, methodName, nextResultNodeClass);
            method.invoke(resultNode, nextResultNode);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private Class<?> getNextResultNodeClass(ReferenceProperty referenceProperty) {
        Multiplicity multiplicity = referenceProperty.getMultiplicity();
        if (multiplicity.isToOne()) {
            Classifier classifier = referenceProperty.getType();
            String dtoFQCN = classifier.getPackageName() + ".dto." + classifier.getName() + "DTO";
            return this.reflectionCache.classForName(dtoFQCN);
        }
        if (multiplicity.isToMany()) {
            return List.class;
        }
        throw new AssertionError((Object)("Unknown multiplicity: " + String.valueOf(multiplicity)));
    }

    @Nonnull
    private Object instantiateDTO(Classifier classifier) {
        if (classifier.isAbstract()) {
            String detailMessage = "Cannot instantiate abstract class: " + String.valueOf(classifier);
            throw new AssertionError((Object)detailMessage);
        }
        String dtoFQCN = classifier.getPackageName() + ".dto." + classifier.getName() + "DTO";
        try {
            Class<?> aClass = this.reflectionCache.classForName(dtoFQCN);
            return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not construct " + dtoFQCN, e);
        }
    }

    private record State(ImmutableStack<Object> contextStack, ImmutableStack<AbstractRelatedFinder> finderStack, ImmutableStack<Object> persistentInstanceStack, ImmutableStack<Object> resultNodeStack) {
    }
}

