/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.reladomo.tree.serializer;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.meta.domain.api.Enumeration;
import cool.klass.model.meta.domain.api.property.EnumerationProperty;
import cool.klass.model.meta.domain.api.property.PrimitiveProperty;
import cool.klass.model.meta.domain.api.visitor.DataTypePropertyVisitor;
import cool.klass.reladomo.tree.serializer.ReflectionCache;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionSetterDataTypePropertyVisitor
implements DataTypePropertyVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionSetterDataTypePropertyVisitor.class);
    private static final Converter<String, String> LOWER_TO_UPPER_CAMEL = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private final ReflectionCache reflectionCache;
    private final Object object;
    private final Object primitiveValue;

    public ReflectionSetterDataTypePropertyVisitor(ReflectionCache reflectionCache, Object object, Object primitiveValue) {
        this.reflectionCache = Objects.requireNonNull(reflectionCache);
        this.object = Objects.requireNonNull(object);
        this.primitiveValue = Objects.requireNonNull(primitiveValue);
    }

    public void visitEnumerationProperty(EnumerationProperty enumerationProperty) {
        String propertyName = enumerationProperty.getName();
        String methodName = "set" + (String)LOWER_TO_UPPER_CAMEL.convert((Object)propertyName);
        Enumeration type = enumerationProperty.getType();
        String dtoFQCN = type.getPackageName() + ".dto." + type.getName() + "DTO";
        Class<?> objectClass = this.object.getClass();
        try {
            Class<?> aClass = this.reflectionCache.classForName(dtoFQCN);
            Method method = this.reflectionCache.getMethod(objectClass, methodName, aClass);
            Object enumConstant = Enum.valueOf(aClass, this.primitiveValue.toString());
            method.invoke(this.object, enumConstant);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitString(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, String.class);
    }

    public void visitInteger(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Integer.class);
    }

    public void visitLong(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Long.class);
    }

    public void visitDouble(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Double.class);
    }

    public void visitFloat(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Float.class);
    }

    public void visitBoolean(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Boolean.class);
    }

    public void visitInstant(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Instant.class);
    }

    public void visitLocalDate(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, LocalDate.class);
    }

    public void visitTemporalInstant(PrimitiveProperty primitiveProperty) {
        this.visitPrimitiveProperty(primitiveProperty, Instant.class);
    }

    public void visitTemporalRange(PrimitiveProperty primitiveProperty) {
        LOGGER.info("{}.visitTemporalRange() not implemented yet", (Object)this.getClass().getSimpleName());
    }

    private void visitPrimitiveProperty(PrimitiveProperty primitiveProperty, Class<?> ... parameterTypes) {
        Class<?> objectClass = this.object.getClass();
        String propertyName = primitiveProperty.getName();
        String methodName = "set" + (String)LOWER_TO_UPPER_CAMEL.convert((Object)propertyName);
        Method method = this.reflectionCache.getMethod(objectClass, methodName, parameterTypes);
        try {
            method.invoke(this.object, this.primitiveValue);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

