/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.service.klass.html;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import cool.klass.generator.klass.html.KlassSourceCodeHtmlGenerator;
import cool.klass.model.meta.domain.api.NamedElement;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import cool.klass.model.meta.domain.api.source.ElementWithSourceCode;
import cool.klass.model.meta.domain.api.source.EnumerationWithSourceCode;
import cool.klass.model.meta.domain.api.source.KlassWithSourceCode;
import cool.klass.model.meta.domain.api.source.NamedElementWithSourceCode;
import cool.klass.model.meta.domain.api.source.SourceCode;
import cool.klass.model.meta.domain.api.source.TopLevelElementWithSourceCode;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;

@Path(value="/")
public class KlassHtmlResource {
    @Nonnull
    private final DomainModelWithSourceCode domainModel;

    public KlassHtmlResource(@Nonnull DomainModelWithSourceCode domainModel) {
        this.domainModel = Objects.requireNonNull(domainModel);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/code/element/{topLevelElementName}")
    @Produces(value={"text/html"})
    public String topLevelElementNameSourceCode(@PathParam(value="topLevelElementName") String topLevelElementName) {
        TopLevelElementWithSourceCode topLevelElement = this.domainModel.getTopLevelElementByName(topLevelElementName);
        if (topLevelElement == null) {
            String message = this.domainModel.getTopLevelElements().selectInstancesOf(NamedElementWithSourceCode.class).collect(NamedElement::getName).toString();
            throw new NotFoundException(message);
        }
        Optional<SourceCode> sourceCode = KlassHtmlResource.getSourceCodeObject(topLevelElement, null);
        if (sourceCode.isEmpty()) {
            throw new BadRequestException();
        }
        return KlassSourceCodeHtmlGenerator.getSourceCode((DomainModelWithSourceCode)this.domainModel, (SourceCode)sourceCode.get(), Optional.of(topLevelElement), Optional.empty());
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/code/element/{topLevelElementName}/{memberName}")
    @Produces(value={"text/html"})
    public String topLevelElementNameSourceCode(@PathParam(value="topLevelElementName") String topLevelElementName, @PathParam(value="memberName") String memberName) {
        TopLevelElementWithSourceCode topLevelElement = this.domainModel.getTopLevelElementByName(topLevelElementName);
        if (topLevelElement == null) {
            String message = this.domainModel.getTopLevelElements().selectInstancesOf(NamedElementWithSourceCode.class).collect(NamedElement::getName).toString();
            throw new NotFoundException(message);
        }
        Optional<SourceCode> sourceCode = KlassHtmlResource.getSourceCodeObject(topLevelElement, memberName);
        if (sourceCode.isEmpty()) {
            throw new BadRequestException();
        }
        return KlassSourceCodeHtmlGenerator.getSourceCode((DomainModelWithSourceCode)this.domainModel, (SourceCode)sourceCode.get(), Optional.of(topLevelElement), Optional.of(memberName));
    }

    @Nonnull
    private static Optional<SourceCode> getSourceCodeObject(TopLevelElementWithSourceCode topLevelElement, String memberName) {
        Object t;
        if (memberName == null) {
            return Optional.of(topLevelElement.getSourceCodeObject());
        }
        if (topLevelElement instanceof KlassWithSourceCode) {
            KlassWithSourceCode klass = (KlassWithSourceCode)topLevelElement;
            Optional property = klass.getPropertyByName(memberName);
            if (property.isEmpty()) {
                return Optional.empty();
            }
            t = property.get();
            if (t instanceof ElementWithSourceCode) {
                ElementWithSourceCode elementWithSourceCode = (ElementWithSourceCode)t;
                return Optional.of(elementWithSourceCode.getSourceCodeObject());
            }
        }
        if (topLevelElement instanceof EnumerationWithSourceCode) {
            EnumerationWithSourceCode enumeration = (EnumerationWithSourceCode)topLevelElement;
            Optional enumerationLiteral = enumeration.getEnumerationLiterals().detectOptional((Predicate & Serializable)each -> each.getName().equals(memberName));
            if (enumerationLiteral.isEmpty()) {
                return Optional.empty();
            }
            t = enumerationLiteral.get();
            if (t instanceof ElementWithSourceCode) {
                ElementWithSourceCode elementWithSourceCode = (ElementWithSourceCode)t;
                return Optional.of(elementWithSourceCode.getSourceCodeObject());
            }
        }
        throw new AssertionError(topLevelElement);
    }

    @Timed
    @ExceptionMetered
    @GET
    @Path(value="/meta/code/file/{fileName}.html")
    @Produces(value={"text/html"})
    public String fileSourceCode(@PathParam(value="fileName") String fileName) {
        ImmutableList sourceCodes = this.domainModel.getSourceCodes().select((Predicate & Serializable)each -> each.getSourceName().equals(fileName));
        if (sourceCodes.size() != 1) {
            throw new NotFoundException(this.domainModel.getSourceCodes().collect(SourceCode::getSourceName).toString());
        }
        SourceCode sourceCode = (SourceCode)sourceCodes.getOnly();
        return KlassSourceCodeHtmlGenerator.getSourceCode((DomainModelWithSourceCode)this.domainModel, (SourceCode)sourceCode, Optional.empty(), Optional.empty());
    }
}

