/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.servlet.filter.mdc.jsonview;

import cool.klass.model.meta.domain.api.projection.Projection;
import io.liftwizard.logging.slf4j.mdc.MultiMDCCloseable;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=4990)
public class JsonViewFilter
implements ContainerRequestFilter {
    private final Projection projection;

    public JsonViewFilter(Projection projection) {
        this.projection = Objects.requireNonNull(projection);
    }

    public void filter(ContainerRequestContext requestContext) {
        MultiMDCCloseable mdc = (MultiMDCCloseable)requestContext.getProperty("mdc");
        mdc.put("klass.jsonView.projectionName", String.valueOf(this.projection));
        mdc.put("klass.jsonView.projectionClassifier", this.projection.getClassifier().getFullyQualifiedName());
    }
}

