/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.syntax.generator.css.token;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import cool.klass.model.converter.compiler.token.categories.TokenCategory;

public final class TokenCategoryToCss {
    public static final Converter<String, String> CONVERTER = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN);

    private TokenCategoryToCss() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void main(String[] args) {
        for (TokenCategory tokenCategory : TokenCategory.values()) {
            String result = ".klass-" + TokenCategoryToCss.getTokenCategoryName(tokenCategory) + " {\n    color: " + TokenCategoryToCss.getCssVar(tokenCategory) + ";\n}\n";
            System.out.print(result);
        }
    }

    private static String getCssVar(TokenCategory tokenCategory) {
        TokenCategory parentCategory = tokenCategory.getParentCategory();
        String fallbackCssVar = parentCategory == null ? "--color-foreground" : TokenCategoryToCss.getCssVar(parentCategory);
        return String.format("var(--klass-color-%s, %s)", TokenCategoryToCss.getTokenCategoryName(tokenCategory), fallbackCssVar);
    }

    private static String getTokenCategoryName(TokenCategory tokenCategory) {
        return (String)CONVERTER.convert((Object)tokenCategory.name());
    }
}

