/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme;

import com.fasterxml.jackson.databind.ObjectMapper;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.AnsiColorScheme;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.JsonAnsiColorScheme;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto.ColorSchemeDefinition;
import io.dropwizard.jersey.validation.Validators;
import io.liftwizard.serialization.jackson.config.ObjectMapperConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorSchemeProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorSchemeProvider.class);
    private static final String COLOR_SCHEME_PATH = "klass/color-scheme/";
    private static final Validator VALIDATOR = Validators.newValidator();

    private ColorSchemeProvider() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static AnsiColorScheme getByName(String schemeName) {
        Objects.requireNonNull(schemeName, "schemeName");
        String jsonPath = COLOR_SCHEME_PATH + schemeName.toLowerCase(Locale.ROOT) + ".json";
        return ColorSchemeProvider.getByClasspath(jsonPath);
    }

    public static boolean existsByName(String schemeName) {
        boolean bl;
        block9: {
            if (schemeName == null) {
                return false;
            }
            String jsonPath = COLOR_SCHEME_PATH + schemeName.toLowerCase(Locale.ROOT) + ".json";
            InputStream inputStream = ColorSchemeProvider.class.getClassLoader().getResourceAsStream(jsonPath);
            try {
                boolean bl2 = bl = inputStream != null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Error checking color scheme existence: {}", (Object)e.getMessage());
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static AnsiColorScheme getByClasspath(String path) {
        try (InputStream inputStream = ColorSchemeProvider.class.getClassLoader().getResourceAsStream(path);){
            if (inputStream == null) {
                throw new IllegalArgumentException("No color scheme found for path " + path);
            }
            ObjectMapper objectMapper = ObjectMapperConfig.configure((ObjectMapper)new ObjectMapper());
            ColorSchemeDefinition colorSchemeDefinition = (ColorSchemeDefinition)objectMapper.readValue(inputStream, ColorSchemeDefinition.class);
            Set violations = VALIDATOR.validate((Object)colorSchemeDefinition, new Class[0]);
            if (violations.isEmpty()) {
                JsonAnsiColorScheme jsonAnsiColorScheme = new JsonAnsiColorScheme(colorSchemeDefinition);
                return jsonAnsiColorScheme;
            }
            StringBuilder errorMessage = new StringBuilder("Color scheme validation errors:");
            Iterator iterator = violations.iterator();
            while (iterator.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)iterator.next();
                errorMessage.append("\n  - ").append(violation.getPropertyPath()).append(": ").append(violation.getMessage());
            }
            throw new IllegalArgumentException(errorMessage.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load color scheme from " + path, e);
        }
    }
}

