/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme;

import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.AnsiColorScheme;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto.ColorSchemeDefinition;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto.ColorSchemeRule;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto.StyleSettings;
import java.awt.Color;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAnsiColorScheme
implements AnsiColorScheme {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonAnsiColorScheme.class);
    private static final ImmutableMap<String, String> FALLBACK_RULES = JsonAnsiColorScheme.getFallbacks();
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("#[0-9A-Fa-f]{6}([0-9A-Fa-f]{2})?");
    private final ColorSchemeDefinition definition;
    private final MapIterable<String, ColorSchemeRule> ruleMap;

    public JsonAnsiColorScheme(ColorSchemeDefinition definition) {
        this.definition = Objects.requireNonNull(definition);
        this.ruleMap = definition.toRuleMap();
    }

    public static ImmutableSet<String> getValidRuleNames() {
        MutableSet validRules = Sets.mutable.empty();
        validRules.addAllIterable((Iterable)FALLBACK_RULES.keysView());
        validRules.addAllIterable((Iterable)FALLBACK_RULES.valuesView());
        validRules.add((Object)"background");
        validRules.add((Object)"foreground");
        return validRules.toImmutable();
    }

    private static ImmutableMap<String, String> getFallbacks() {
        MutableMap fallbacks = Maps.mutable.empty();
        fallbacks.put((Object)"lineComment", (Object)"blockComment");
        fallbacks.put((Object)"packageKeyword", (Object)"keyword");
        fallbacks.put((Object)"primitiveType", (Object)"keyword");
        fallbacks.put((Object)"verb", (Object)"keyword");
        fallbacks.put((Object)"modifier", (Object)"keyword");
        fallbacks.put((Object)"classifierModifier", (Object)"modifier");
        fallbacks.put((Object)"dataTypePropertyModifier", (Object)"modifier");
        fallbacks.put((Object)"associationEndModifier", (Object)"modifier");
        fallbacks.put((Object)"parameterizedPropertyModifier", (Object)"modifier");
        fallbacks.put((Object)"parameterModifier", (Object)"modifier");
        fallbacks.put((Object)"validationModifier", (Object)"modifier");
        fallbacks.put((Object)"serviceCategoryModifier", (Object)"modifier");
        fallbacks.put((Object)"packageName", (Object)"identifier");
        fallbacks.put((Object)"topLevelElementName", (Object)"identifier");
        fallbacks.put((Object)"enumerationLiteralName", (Object)"identifier");
        fallbacks.put((Object)"parameterName", (Object)"identifier");
        fallbacks.put((Object)"propertyName", (Object)"identifier");
        fallbacks.put((Object)"urlConstant", (Object)"identifier");
        fallbacks.put((Object)"enumerationName", (Object)"topLevelElementName");
        fallbacks.put((Object)"classifierName", (Object)"topLevelElementName");
        fallbacks.put((Object)"associationName", (Object)"topLevelElementName");
        fallbacks.put((Object)"projectionName", (Object)"topLevelElementName");
        fallbacks.put((Object)"serviceName", (Object)"topLevelElementName");
        fallbacks.put((Object)"className", (Object)"classifierName");
        fallbacks.put((Object)"interfaceName", (Object)"classifierName");
        fallbacks.put((Object)"dataTypePropertyName", (Object)"propertyName");
        fallbacks.put((Object)"referencePropertyName", (Object)"propertyName");
        fallbacks.put((Object)"primitivePropertyName", (Object)"dataTypePropertyName");
        fallbacks.put((Object)"enumerationPropertyName", (Object)"dataTypePropertyName");
        fallbacks.put((Object)"parameterizedPropertyName", (Object)"referencePropertyName");
        fallbacks.put((Object)"associationEndName", (Object)"referencePropertyName");
        fallbacks.put((Object)"enumerationReference", (Object)"enumerationName");
        fallbacks.put((Object)"classifierReference", (Object)"classifierName");
        fallbacks.put((Object)"interfaceReference", (Object)"interfaceName");
        fallbacks.put((Object)"classReference", (Object)"className");
        fallbacks.put((Object)"projectionReference", (Object)"projectionName");
        fallbacks.put((Object)"dataTypePropertyReference", (Object)"propertyName");
        fallbacks.put((Object)"associationEndReference", (Object)"associationEndName");
        fallbacks.put((Object)"parameterizedPropertyReference", (Object)"parameterizedPropertyName");
        fallbacks.put((Object)"propertyReference", (Object)"propertyName");
        fallbacks.put((Object)"parameterReference", (Object)"parameterName");
        fallbacks.put((Object)"stringLiteral", (Object)"literal");
        fallbacks.put((Object)"integerLiteral", (Object)"literal");
        fallbacks.put((Object)"booleanLiteral", (Object)"literal");
        fallbacks.put((Object)"characterLiteral", (Object)"literal");
        fallbacks.put((Object)"floatingPointLiteral", (Object)"literal");
        fallbacks.put((Object)"literalThis", (Object)"literal");
        fallbacks.put((Object)"literalNative", (Object)"literal");
        fallbacks.put((Object)"comma", (Object)"punctuation");
        fallbacks.put((Object)"dot", (Object)"punctuation");
        fallbacks.put((Object)"semi", (Object)"punctuation");
        fallbacks.put((Object)"operator", (Object)"punctuation");
        fallbacks.put((Object)"dotDot", (Object)"dot");
        return fallbacks.toImmutable();
    }

    private void applyRule(String ruleName, Ansi ansi) {
        ColorSchemeRule rule = this.getColorSchemeRule(ruleName);
        StyleSettings style = rule.style();
        if (style.foreground() != null) {
            this.applyColor(ansi, style.foreground(), true);
        }
        if (style.background() != null) {
            this.applyColor(ansi, style.background(), false);
        }
    }

    private void applyColor(Ansi ansi, Object colorValue, boolean isForeground) {
        if (colorValue instanceof String) {
            JsonAnsiColorScheme.applyColorString(ansi, (String)colorValue, isForeground);
        } else if (colorValue instanceof Number) {
            JsonAnsiColorScheme.applyColorNumber(ansi, (Number)colorValue, isForeground);
        } else if (colorValue == null) {
            LOGGER.warn("Null color value provided");
        } else {
            LOGGER.warn("Unsupported color value type: {}", (Object)colorValue.getClass().getName());
        }
    }

    private static void applyColorString(Ansi ansi, String colorValue, boolean isForeground) {
        if (colorValue.startsWith("#") && HEX_COLOR_PATTERN.matcher(colorValue).matches()) {
            JsonAnsiColorScheme.applyColorRGB(ansi, isForeground, colorValue);
        } else {
            JsonAnsiColorScheme.applyColorNamed(ansi, isForeground, colorValue);
        }
    }

    private static void applyColorRGB(Ansi ansi, boolean isForeground, String colorStr) {
        Color decodedColor = Color.decode(colorStr);
        int r = decodedColor.getRed();
        int g = decodedColor.getGreen();
        int b = decodedColor.getBlue();
        if (isForeground) {
            ansi.fgRgb(r, g, b);
        } else {
            ansi.bgRgb(r, g, b);
        }
    }

    private static void applyColorNamed(Ansi ansi, boolean isForeground, String colorStr) {
        try {
            Ansi.Color namedColor = Ansi.Color.valueOf((String)colorStr);
            if (isForeground) {
                ansi.fg(namedColor);
            } else {
                ansi.bg(namedColor);
            }
        }
        catch (IllegalArgumentException e) {
            String detailMessage = "Invalid color name: '" + colorStr + "'. Must be a valid ANSI color enum, integer, or RGB hex format (#RRGGBB). Valid enum values are: " + ArrayAdapter.adapt((Object[])Ansi.Color.values()).makeString();
            throw new IllegalArgumentException(detailMessage);
        }
    }

    private static void applyColorNumber(Ansi ansi, Number colorValue, boolean isForeground) {
        int colorCode = colorValue.intValue();
        if (isForeground) {
            ansi.fg(colorCode);
        } else {
            ansi.bg(colorCode);
        }
    }

    @Nonnull
    private ColorSchemeRule getColorSchemeRule(String ruleName) {
        String eachRuleName = ruleName;
        MutableSet visitedRules = Sets.mutable.empty();
        while (true) {
            if (visitedRules.contains((Object)eachRuleName)) {
                throw new IllegalStateException("Circular rule reference detected: " + visitedRules);
            }
            visitedRules.add((Object)eachRuleName);
            if (eachRuleName == null) {
                throw new IllegalArgumentException("No rule found for: " + ruleName + " in " + this.definition.name());
            }
            ColorSchemeRule result = (ColorSchemeRule)this.ruleMap.get((Object)eachRuleName);
            if (result != null) {
                return result;
            }
            eachRuleName = (String)FALLBACK_RULES.get((Object)eachRuleName);
        }
    }

    @Override
    public void background(Ansi ansi) {
        this.applyRule("background", ansi);
    }

    @Override
    public void blockComment(Ansi ansi) {
        this.applyRule("blockComment", ansi);
    }

    @Override
    public void lineComment(Ansi ansi) {
        this.applyRule("lineComment", ansi);
    }

    @Override
    public void keyword(Ansi ansi) {
        this.applyRule("keyword", ansi);
    }

    @Override
    public void packageKeyword(Ansi ansi) {
        this.applyRule("packageKeyword", ansi);
    }

    @Override
    public void primitiveType(Ansi ansi) {
        this.applyRule("primitiveType", ansi);
    }

    @Override
    public void verb(Ansi ansi) {
        this.applyRule("verb", ansi);
    }

    @Override
    public void modifier(Ansi ansi) {
        this.applyRule("modifier", ansi);
    }

    @Override
    public void classifierModifier(Ansi ansi) {
        this.applyRule("classifierModifier", ansi);
    }

    @Override
    public void dataTypePropertyModifier(Ansi ansi) {
        this.applyRule("dataTypePropertyModifier", ansi);
    }

    @Override
    public void associationEndModifier(Ansi ansi) {
        this.applyRule("associationEndModifier", ansi);
    }

    @Override
    public void parameterizedPropertyModifier(Ansi ansi) {
        this.applyRule("parameterizedPropertyModifier", ansi);
    }

    @Override
    public void parameterModifier(Ansi ansi) {
        this.applyRule("parameterModifier", ansi);
    }

    @Override
    public void validationModifier(Ansi ansi) {
        this.applyRule("validationModifier", ansi);
    }

    @Override
    public void serviceCategoryModifier(Ansi ansi) {
        this.applyRule("serviceCategoryModifier", ansi);
    }

    @Override
    public void identifier(Ansi ansi) {
        this.applyRule("identifier", ansi);
    }

    @Override
    public void packageName(Ansi ansi) {
        this.applyRule("packageName", ansi);
    }

    @Override
    public void topLevelElementName(Ansi ansi) {
        this.applyRule("topLevelElementName", ansi);
    }

    @Override
    public void enumerationName(Ansi ansi) {
        this.applyRule("enumerationName", ansi);
    }

    @Override
    public void classifierName(Ansi ansi) {
        this.applyRule("classifierName", ansi);
    }

    @Override
    public void className(Ansi ansi) {
        this.applyRule("className", ansi);
    }

    @Override
    public void interfaceName(Ansi ansi) {
        this.applyRule("interfaceName", ansi);
    }

    @Override
    public void associationName(Ansi ansi) {
        this.applyRule("associationName", ansi);
    }

    @Override
    public void projectionName(Ansi ansi) {
        this.applyRule("projectionName", ansi);
    }

    @Override
    public void serviceName(Ansi ansi) {
        this.applyRule("serviceName", ansi);
    }

    @Override
    public void enumerationLiteralName(Ansi ansi) {
        this.applyRule("enumerationLiteralName", ansi);
    }

    @Override
    public void parameterName(Ansi ansi) {
        this.applyRule("parameterName", ansi);
    }

    @Override
    public void propertyName(Ansi ansi) {
        this.applyRule("propertyName", ansi);
    }

    @Override
    public void dataTypePropertyName(Ansi ansi) {
        this.applyRule("dataTypePropertyName", ansi);
    }

    @Override
    public void primitivePropertyName(Ansi ansi) {
        this.applyRule("primitivePropertyName", ansi);
    }

    @Override
    public void enumerationPropertyName(Ansi ansi) {
        this.applyRule("enumerationPropertyName", ansi);
    }

    @Override
    public void referencePropertyName(Ansi ansi) {
        this.applyRule("referencePropertyName", ansi);
    }

    @Override
    public void parameterizedPropertyName(Ansi ansi) {
        this.applyRule("parameterizedPropertyName", ansi);
    }

    @Override
    public void associationEndName(Ansi ansi) {
        this.applyRule("associationEndName", ansi);
    }

    @Override
    public void enumerationReference(Ansi ansi) {
        this.applyRule("enumerationReference", ansi);
    }

    @Override
    public void classifierReference(Ansi ansi) {
        this.applyRule("classifierReference", ansi);
    }

    @Override
    public void interfaceReference(Ansi ansi) {
        this.applyRule("interfaceReference", ansi);
    }

    @Override
    public void classReference(Ansi ansi) {
        this.applyRule("classReference", ansi);
    }

    @Override
    public void projectionReference(Ansi ansi) {
        this.applyRule("projectionReference", ansi);
    }

    @Override
    public void dataTypePropertyReference(Ansi ansi) {
        this.applyRule("dataTypePropertyReference", ansi);
    }

    @Override
    public void associationEndReference(Ansi ansi) {
        this.applyRule("associationEndReference", ansi);
    }

    @Override
    public void parameterizedPropertyReference(Ansi ansi) {
        this.applyRule("parameterizedPropertyReference", ansi);
    }

    @Override
    public void propertyReference(Ansi ansi) {
        this.applyRule("propertyReference", ansi);
    }

    @Override
    public void parameterReference(Ansi ansi) {
        this.applyRule("parameterReference", ansi);
    }

    @Override
    public void literal(Ansi ansi) {
        this.applyRule("literal", ansi);
    }

    @Override
    public void stringLiteral(Ansi ansi) {
        this.applyRule("stringLiteral", ansi);
    }

    @Override
    public void integerLiteral(Ansi ansi) {
        this.applyRule("integerLiteral", ansi);
    }

    @Override
    public void booleanLiteral(Ansi ansi) {
        this.applyRule("booleanLiteral", ansi);
    }

    @Override
    public void characterLiteral(Ansi ansi) {
        this.applyRule("characterLiteral", ansi);
    }

    @Override
    public void floatingPointLiteral(Ansi ansi) {
        this.applyRule("floatingPointLiteral", ansi);
    }

    @Override
    public void literalThis(Ansi ansi) {
        this.applyRule("literalThis", ansi);
    }

    @Override
    public void literalNative(Ansi ansi) {
        this.applyRule("literalNative", ansi);
    }

    @Override
    public void punctuation(Ansi ansi) {
        this.applyRule("punctuation", ansi);
    }

    @Override
    public void comma(Ansi ansi) {
        this.applyRule("comma", ansi);
    }

    @Override
    public void dot(Ansi ansi) {
        this.applyRule("dot", ansi);
    }

    @Override
    public void dotDot(Ansi ansi) {
        this.applyRule("dotDot", ansi);
    }

    @Override
    public void semi(Ansi ansi) {
        this.applyRule("semi", ansi);
    }

    @Override
    public void operator(Ansi ansi) {
        this.applyRule("operator", ansi);
    }

    @Override
    public void urlConstant(Ansi ansi) {
        this.applyRule("urlConstant", ansi);
    }
}

