/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.JsonAnsiColorScheme;
import cool.klass.model.converter.compiler.syntax.highlighter.ansi.scheme.dto.ColorSchemeRule;
import io.dropwizard.validation.ValidationMethod;
import java.io.Serializable;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ColorSchemeDefinition(@NotBlank(message="Color scheme name is required") @Nonnull @NotBlank(message="Color scheme name is required") String name, @NotNull(message="Color scheme description is required") @NotNull(message="Color scheme description is required") String description, @NotEmpty(message="Color scheme must define at least one rule") @NotNull(message="Rules list cannot be null") @Valid @NotEmpty(message="Color scheme must define at least one rule") @NotNull(message="Rules list cannot be null") @Valid MutableList<ColorSchemeRule> rules) {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorSchemeDefinition.class);

    @ValidationMethod(message="Color scheme must define a 'background' rule")
    @JsonIgnore
    public boolean hasBackgroundRule() {
        return this.rules.anySatisfy((Predicate & Serializable)rule -> "background".equals(rule.name()));
    }

    @ValidationMethod(message="Unknown rule name in color scheme")
    @JsonIgnore
    public boolean hasValidRuleNames() {
        ImmutableSet<String> validRuleNames = JsonAnsiColorScheme.getValidRuleNames();
        MutableSet schemeRuleNames = this.rules.collect(ColorSchemeRule::name).toSet();
        MutableSet invalidRuleNames = schemeRuleNames.reject(arg_0 -> validRuleNames.contains(arg_0));
        if (invalidRuleNames.notEmpty()) {
            LOGGER.warn("Unknown rule name(s) found in color scheme: {}", (Object)invalidRuleNames.makeString(", "));
            return false;
        }
        return true;
    }

    public MapIterable<String, ColorSchemeRule> toRuleMap() {
        MutableOrderedMap result = OrderedMapAdapter.adapt(new LinkedHashMap());
        return ((MutableOrderedMap)this.rules.groupByUniqueKey(ColorSchemeRule::name, (MutableMapIterable)result)).asUnmodifiable();
    }
}

