/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.token.categorizing.lexer;

import cool.klass.model.converter.compiler.token.categories.TokenCategory;
import java.util.LinkedHashMap;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public final class LexerBasedTokenCategorizer {
    private LexerBasedTokenCategorizer() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static MapIterable<Token, TokenCategory> findTokenCategoriesFromLexer(BufferedTokenStream tokenStream) {
        MutableOrderedMap tokenCategories = OrderedMapAdapter.adapt(new LinkedHashMap());
        LexerBasedTokenCategorizer.findTokenCategoriesFromLexer(tokenStream, (MutableMapIterable<Token, TokenCategory>)tokenCategories);
        return tokenCategories.asUnmodifiable();
    }

    public static void findTokenCategoriesFromLexer(BufferedTokenStream tokenStream, MutableMapIterable<Token, TokenCategory> tokenCategories) {
        for (Token token : tokenStream.getTokens()) {
            LexerBasedTokenCategorizer.findTokenCategoriesFromLexer(token, tokenCategories);
        }
    }

    private static void findTokenCategoriesFromLexer(Token token, MutableMapIterable<Token, TokenCategory> tokenCategories) {
        TokenCategory tokenCategory = LexerBasedTokenCategorizer.getTokenCategory(token);
        if (tokenCategory == null) {
            return;
        }
        TokenCategory duplicate = (TokenCategory)tokenCategories.put((Object)token, (Object)tokenCategory);
        if (duplicate != null) {
            throw new AssertionError(token);
        }
    }

    private static TokenCategory getTokenCategory(Token token) {
        int channel = token.getChannel();
        if (channel == 2000) {
            return TokenCategory.BLOCK_COMMENT;
        }
        if (channel == 3000) {
            return TokenCategory.LINE_COMMENT;
        }
        return switch (token.getType()) {
            case 118 -> TokenCategory.STRING_LITERAL;
            case 112 -> TokenCategory.INTEGER_LITERAL;
            case 114 -> TokenCategory.BOOLEAN_LITERAL;
            case 117 -> TokenCategory.CHARACTER_LITERAL;
            case 113 -> TokenCategory.FLOATING_POINT_LITERAL;
            case 75 -> TokenCategory.PARENTHESIS_LEFT;
            case 76 -> TokenCategory.PARENTHESIS_RIGHT;
            case 77 -> TokenCategory.CURLY_LEFT;
            case 78 -> TokenCategory.CURLY_RIGHT;
            case 79 -> TokenCategory.SQUARE_BRACKET_LEFT;
            case 80 -> TokenCategory.SQUARE_BRACKET_RIGHT;
            case 82 -> TokenCategory.COLON;
            case 86 -> TokenCategory.SLASH;
            case 88 -> TokenCategory.QUESTION;
            case 83 -> TokenCategory.COMMA;
            case 85 -> TokenCategory.DOTDOT;
            case 84 -> TokenCategory.DOT;
            case 81 -> TokenCategory.SEMICOLON;
            case 96 -> TokenCategory.OPERATOR_EQ;
            case 97 -> TokenCategory.OPERATOR_NE;
            case 98 -> TokenCategory.OPERATOR_LT;
            case 99 -> TokenCategory.OPERATOR_GT;
            case 100 -> TokenCategory.OPERATOR_LE;
            case 101 -> TokenCategory.OPERATOR_GE;
            case 106 -> TokenCategory.OPERATOR_AND;
            case 107 -> TokenCategory.OPERATOR_OR;
            default -> null;
        };
    }
}

