/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.model.converter.compiler.token.categorizing.parser;

import cool.klass.model.converter.compiler.token.categories.TokenCategory;
import cool.klass.model.meta.grammar.KlassBaseListener;
import cool.klass.model.meta.grammar.KlassParser;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.impl.map.ordered.mutable.OrderedMapAdapter;

public class ParserBasedTokenCategorizer
extends KlassBaseListener {
    @Nonnull
    private final MutableMapIterable<Token, TokenCategory> tokenCategories = OrderedMapAdapter.adapt(new LinkedHashMap());

    @Nonnull
    public MutableMapIterable<Token, TokenCategory> getTokenCategories() {
        return this.tokenCategories.asUnmodifiable();
    }

    @Nonnull
    public static MapIterable<Token, TokenCategory> findTokenCategoriesFromParser(@Nonnull ParseTree parseTree) {
        ParserBasedTokenCategorizer listener = new ParserBasedTokenCategorizer();
        ParserBasedTokenCategorizer.findTokenCategoriesFromParser(parseTree, (ParseTreeListener)listener);
        return listener.tokenCategories.asUnmodifiable();
    }

    public static void findTokenCategoriesFromParser(ParseTree parseTree, ParseTreeListener listener) {
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk(listener, parseTree);
    }

    public void enterPackageDeclaration(KlassParser.PackageDeclarationContext ctx) {
        this.put(ctx.KEYWORD_PACKAGE().getSymbol(), TokenCategory.PACKAGE_KEYWORD);
    }

    public void enterPackageName(KlassParser.PackageNameContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PACKAGE_NAME);
    }

    public void enterClassOrUser(KlassParser.ClassOrUserContext ctx) {
        if (ctx.KEYWORD_USER() != null) {
            this.put(ctx.getStart(), TokenCategory.KEYWORD_USER);
        } else if (ctx.KEYWORD_CLASS() != null) {
            this.put(ctx.getStart(), TokenCategory.KEYWORD_CLASS);
        } else {
            throw new AssertionError(ctx);
        }
    }

    public void enterClassHeader(KlassParser.ClassHeaderContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.CLASS_NAME);
    }

    public void enterAbstractDeclaration(KlassParser.AbstractDeclarationContext ctx) {
        this.put(ctx.KEYWORD_ABSTRACT().getSymbol(), TokenCategory.KEYWORD_ABSTRACT);
    }

    public void enterExtendsDeclaration(KlassParser.ExtendsDeclarationContext ctx) {
        this.put(ctx.KEYWORD_EXTENDS().getSymbol(), TokenCategory.KEYWORD_EXTENDS);
    }

    public void enterImplementsDeclaration(KlassParser.ImplementsDeclarationContext ctx) {
        this.put(ctx.KEYWORD_IMPLEMENTS().getSymbol(), TokenCategory.KEYWORD_IMPLEMENTS);
    }

    public void enterAssociationDeclaration(KlassParser.AssociationDeclarationContext ctx) {
        this.put(ctx.KEYWORD_ASSOCIATION().getSymbol(), TokenCategory.KEYWORD_ASSOCIATION);
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_NAME);
    }

    public void enterAssociationEnd(KlassParser.AssociationEndContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_END_NAME);
    }

    public void enterAssociationEndSignature(KlassParser.AssociationEndSignatureContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_END_NAME);
    }

    public void enterClassifierReference(KlassParser.ClassifierReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.CLASSIFIER_REFERENCE);
    }

    public void enterClassReference(KlassParser.ClassReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.CLASS_REFERENCE);
    }

    public void enterInterfaceReference(KlassParser.InterfaceReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.INTERFACE_REFERENCE);
    }

    public void enterEnumerationReference(KlassParser.EnumerationReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ENUMERATION_REFERENCE);
    }

    public void enterProjectionReference(KlassParser.ProjectionReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PROJECTION_REFERENCE);
    }

    public void enterAssociationEndReference(KlassParser.AssociationEndReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_END_REFERENCE);
    }

    public void enterMemberReference(KlassParser.MemberReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PROPERTY_REFERENCE);
    }

    public void enterVariableReference(KlassParser.VariableReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETER_REFERENCE);
    }

    public void enterServiceCategoryModifier(KlassParser.ServiceCategoryModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.SERVICE_CATEGORY_MODIFIER);
    }

    public void enterClassifierModifier(KlassParser.ClassifierModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.CLASSIFIER_MODIFIER);
    }

    public void enterDataTypePropertyModifier(KlassParser.DataTypePropertyModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.DATA_TYPE_PROPERTY_MODIFIER);
    }

    public void enterAssociationEndModifier(KlassParser.AssociationEndModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.ASSOCIATION_END_MODIFIER);
    }

    public void enterParameterizedPropertyModifier(KlassParser.ParameterizedPropertyModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.PARAMETERIZED_PROPERTY_MODIFIER);
    }

    public void enterParameterModifier(KlassParser.ParameterModifierContext ctx) {
        this.put(ctx.getStart(), TokenCategory.PARAMETER_MODIFIER);
    }

    public void enterDataTypePropertyValidation(KlassParser.DataTypePropertyValidationContext ctx) {
        this.put(ctx.getStart(), TokenCategory.VALIDATION_MODIFIER);
    }

    public void enterPrimitiveProperty(KlassParser.PrimitivePropertyContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PRIMITIVE_PROPERTY_NAME);
        this.put(ctx.primitiveType().getStart(), TokenCategory.PRIMITIVE_TYPE);
    }

    public void enterEnumerationProperty(KlassParser.EnumerationPropertyContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ENUMERATION_PROPERTY_NAME);
    }

    public void enterParameterizedProperty(KlassParser.ParameterizedPropertyContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETERIZED_PROPERTY_NAME);
    }

    public void enterParameterizedPropertySignature(KlassParser.ParameterizedPropertySignatureContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETERIZED_PROPERTY_NAME);
    }

    public void enterMultiplicityBody(KlassParser.MultiplicityBodyContext ctx) {
        TerminalNode terminalNode = ctx.PUNCTUATION_ASTERISK();
        if (terminalNode == null) {
            return;
        }
        this.put(terminalNode.getSymbol(), TokenCategory.ASTERISK_LITERAL);
    }

    public void enterEnumerationDeclaration(KlassParser.EnumerationDeclarationContext ctx) {
        this.put(ctx.KEYWORD_ENUMERATION().getSymbol(), TokenCategory.KEYWORD_ENUMERATION);
        this.put(ctx.identifier().getStart(), TokenCategory.ENUMERATION_NAME);
    }

    public void enterEnumerationLiteral(KlassParser.EnumerationLiteralContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ENUMERATION_LITERAL_NAME);
    }

    public void enterInterfaceHeader(KlassParser.InterfaceHeaderContext ctx) {
        this.put(ctx.KEYWORD_INTERFACE().getSymbol(), TokenCategory.KEYWORD_INTERFACE);
        this.put(ctx.identifier().getStart(), TokenCategory.INTERFACE_NAME);
    }

    public void enterProjectionDeclaration(KlassParser.ProjectionDeclarationContext ctx) {
        this.put(ctx.KEYWORD_PROJECTION().getSymbol(), TokenCategory.KEYWORD_PROJECTION);
        this.put(ctx.identifier().getStart(), TokenCategory.PROJECTION_NAME);
        this.put(ctx.KEYWORD_ON().getSymbol(), TokenCategory.KEYWORD_ON);
    }

    public void enterProjectionPrimitiveMember(KlassParser.ProjectionPrimitiveMemberContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.DATA_TYPE_PROPERTY_REFERENCE);
    }

    public void enterProjectionReferenceProperty(KlassParser.ProjectionReferencePropertyContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_END_REFERENCE);
    }

    public void enterProjectionProjectionReference(KlassParser.ProjectionProjectionReferenceContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.ASSOCIATION_END_REFERENCE);
    }

    public void enterProjectionParameterizedProperty(KlassParser.ProjectionParameterizedPropertyContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETERIZED_PROPERTY_REFERENCE);
    }

    public void enterPrimitiveParameterDeclaration(KlassParser.PrimitiveParameterDeclarationContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETER_NAME);
        this.put(ctx.primitiveType().getStart(), TokenCategory.PRIMITIVE_TYPE);
    }

    public void enterEnumerationParameterDeclaration(KlassParser.EnumerationParameterDeclarationContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETER_NAME);
    }

    public void enterInvalidParameterDeclaration(KlassParser.InvalidParameterDeclarationContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.PARAMETER_NAME);
    }

    public void enterRelationship(KlassParser.RelationshipContext ctx) {
        this.put(ctx.KEYWORD_RELATIONSHIP().getSymbol(), TokenCategory.KEYWORD_RELATIONSHIP);
    }

    public void enterOrderByDeclaration(KlassParser.OrderByDeclarationContext ctx) {
        this.put(ctx.KEYWORD_ORDER_BY().getSymbol(), TokenCategory.KEYWORD_ORDER_BY);
    }

    public void enterThisMemberReferencePath(KlassParser.ThisMemberReferencePathContext ctx) {
        this.put(ctx.LITERAL_THIS().getSymbol(), TokenCategory.LITERAL_THIS);
    }

    public void enterOrderByDirection(KlassParser.OrderByDirectionContext ctx) {
        this.put(ctx.getStart(), TokenCategory.KEYWORD_ORDER_BY_DIRECTION);
    }

    public void enterOperator(KlassParser.OperatorContext ctx) {
        if (ctx.inOperator() != null) {
            this.put(ctx.getStart(), TokenCategory.OPERATOR_IN);
        } else if (ctx.stringOperator() != null) {
            this.put(ctx.getStart(), TokenCategory.OPERATOR_STRING);
        }
    }

    public void enterNativeLiteral(KlassParser.NativeLiteralContext ctx) {
        this.put(ctx.getStart(), TokenCategory.LITERAL_NATIVE);
    }

    public void enterNullLiteral(KlassParser.NullLiteralContext ctx) {
        this.put(ctx.getStart(), TokenCategory.KEYWORD);
    }

    public void enterServiceGroupDeclaration(KlassParser.ServiceGroupDeclarationContext ctx) {
        this.put(ctx.KEYWORD_SERVICE().getSymbol(), TokenCategory.KEYWORD_SERVICE);
        this.put(ctx.identifier().getStart(), TokenCategory.SERVICE_NAME);
        this.put(ctx.KEYWORD_ON().getSymbol(), TokenCategory.KEYWORD_ON);
    }

    public void enterUrlConstant(KlassParser.UrlConstantContext ctx) {
        this.put(ctx.identifier().getStart(), TokenCategory.URL_CONSTANT);
    }

    public void enterServiceMultiplicityDeclaration(KlassParser.ServiceMultiplicityDeclarationContext ctx) {
        this.put(ctx.KEYWORD_MULTIPLICITY().getSymbol(), TokenCategory.KEYWORD_MULTIPLICITY);
    }

    public void enterServiceMultiplicity(KlassParser.ServiceMultiplicityContext ctx) {
        this.put(ctx.getStart(), TokenCategory.KEYWORD_MULTIPLICITY_CHOICE);
    }

    public void enterServiceCriteriaKeyword(KlassParser.ServiceCriteriaKeywordContext ctx) {
        this.put(ctx.getStart(), TokenCategory.KEYWORD_SERVICE_CRITERIA);
    }

    public void enterCriteriaEdgePoint(KlassParser.CriteriaEdgePointContext ctx) {
        this.put(ctx.KEYWORD_EQUALS_EDGE_POINT().getSymbol(), TokenCategory.KEYWORD);
    }

    public void enterCriteriaNative(KlassParser.CriteriaNativeContext ctx) {
        this.put(ctx.KEYWORD_NATIVE().getSymbol(), TokenCategory.KEYWORD);
    }

    public void enterCriteriaAll(KlassParser.CriteriaAllContext ctx) {
        this.put(ctx.KEYWORD_ALL().getSymbol(), TokenCategory.KEYWORD);
    }

    public void enterServiceProjectionDispatch(KlassParser.ServiceProjectionDispatchContext ctx) {
        this.put(ctx.KEYWORD_PROJECTION().getSymbol(), TokenCategory.KEYWORD_PROJECTION);
    }

    public void enterVerb(KlassParser.VerbContext ctx) {
        if (ctx.VERB_GET() != null) {
            this.put(ctx.VERB_GET().getSymbol(), TokenCategory.VERB_GET);
        } else if (ctx.VERB_POST() != null) {
            this.put(ctx.VERB_POST().getSymbol(), TokenCategory.VERB_POST);
        } else if (ctx.VERB_PUT() != null) {
            this.put(ctx.VERB_PUT().getSymbol(), TokenCategory.VERB_PUT);
        } else if (ctx.VERB_PATCH() != null) {
            this.put(ctx.VERB_PATCH().getSymbol(), TokenCategory.VERB_PATCH);
        } else if (ctx.VERB_DELETE() != null) {
            this.put(ctx.VERB_DELETE().getSymbol(), TokenCategory.VERB_DELETE);
        } else {
            throw new AssertionError(ctx);
        }
    }

    private void put(Token token, TokenCategory tokenCategory) {
        TokenCategory duplicate = (TokenCategory)this.tokenCategories.put((Object)token, (Object)tokenCategory);
        if (duplicate != null) {
            throw new RuntimeException("Duplicate token: " + token.getText());
        }
    }
}

