/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.base.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class CollectionUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return !CollectionUtil.isNotEmpty(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return null != collection && !collection.isEmpty();
    }

    public static boolean isEmpty(Object[] arr) {
        return !CollectionUtil.isNotEmpty(arr);
    }

    public static boolean isNotEmpty(Object[] arr) {
        return null != arr && arr.length > 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return !CollectionUtil.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && !map.isEmpty();
    }

    public static boolean contains(Object[] arr, Object target) {
        return null != arr && CollectionUtil.indexOf(arr, target) != -1;
    }

    public static int indexOf(Object[] arr, Object target) {
        for (int i = 0; i < arr.length; ++i) {
            if (!Objects.equals(target, arr[i])) continue;
            return i;
        }
        return -1;
    }

    public static int sizeOf(Object obj) {
        if (null == obj) {
            return 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj).length;
        }
        return 1;
    }

    public static boolean containsAny(Collection<?> c1, Collection<?> c2) {
        if (null == c1 || null == c2) {
            return false;
        }
        for (Object o : c1) {
            if (!c2.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getTypeFromObj(Object obj) {
        if (null == obj) {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570: \u7a7a\u5bf9\u8c61");
        }
        if (obj instanceof Collection) {
            if (((Collection)obj).isEmpty()) {
                throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570: \u7a7a\u96c6\u5408");
            }
            return ((Collection)obj).iterator().next().getClass();
        }
        if (obj.getClass().isArray()) {
            if (((Object[])obj).length == 0) {
                throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570: \u7a7a\u6570\u7ec4");
            }
            return ((Object[])obj)[0].getClass();
        }
        return obj.getClass();
    }
}

