/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.base.util;

import cool.lazy.cat.orm.base.constant.Case;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String EMPTY = "";
    private static final Pattern CAMEL_REG = Pattern.compile("([A-Za-z\\d]+)(_)?");
    private static final Pattern UNDER_LINE_REG = Pattern.compile("[A-Z]([a-z\\d]+)?");

    public static boolean isEmpty(CharSequence charSequence) {
        return null == charSequence || charSequence.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringUtil.isEmpty(charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        return null == charSequence || charSequence.toString().trim().length() == 0;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !StringUtil.isBlank(charSequence);
    }

    public static String underline2Camel(String str, boolean lowercase) {
        if (StringUtil.isBlank(str)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = CAMEL_REG.matcher(str);
        while (matcher.find()) {
            String word = matcher.group();
            if (lowercase && matcher.start() == 0) {
                sb.append(Character.toLowerCase(word.charAt(0)));
            } else {
                sb.append(Character.toUpperCase(word.charAt(0)));
            }
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String camel2Underline(String str, Case charCase) {
        if (str == null || EMPTY.equals(str)) {
            return EMPTY;
        }
        str = String.valueOf(str.charAt(0)).toUpperCase().concat(str.substring(1));
        StringBuilder sb = new StringBuilder();
        Matcher matcher = UNDER_LINE_REG.matcher(str);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(charCase == Case.UPPERCASE ? word.toUpperCase() : word.toLowerCase());
            sb.append(matcher.end() == str.length() ? EMPTY : "_");
        }
        return sb.toString();
    }

    public static String upper2Lower(String word) {
        return String.valueOf(word.charAt(0)).toLowerCase().concat(word.substring(1));
    }
}

